% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.R
\name{cca}
\alias{cca}
\title{Canonical Correlation Analysis - CCA}
\usage{
cca(X)
}
\arguments{
\item{X}{\code{list} of input data blocks.}
}
\value{
\code{multiblock} object with associated with printing, scores, loadings. Relevant plotting functions: \code{\link{multiblock_plots}}
and result functions: \code{\link{multiblock_results}}.
}
\description{
This is a wrapper for the \code{stats::cancor} function for computing CCA.
}
\details{
CCA is a method which maximises correlation between linear combinations of the columns of
two blocks, i.e. max(cor(X1 x a, X2 x b)). This is done sequentially with deflation in between, such
that a sequence of correlations and weight vectors a and b are associated with a pair of matrices.
}
\examples{
data(potato)
X <- potato$Chemical

cca.pot  <- cca(potato[1:2])
}
\references{
Hotelling, H. (1936) Relations between two sets of variates. Biometrika, 28, 321–377.
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
Common functions for computation and extraction of results and plotting are found in \code{\link{multiblock_results}} and \code{\link{multiblock_plots}}, respectively.
}
