% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.R
\name{gsvd}
\alias{gsvd}
\title{Generalised Singular Value Decomposition - GSVD}
\usage{
gsvd(X)
}
\arguments{
\item{X}{\code{list} of input data blocks.}
}
\value{
\code{multiblock} object with associated with printing, scores, loadings. Relevant plotting functions: \code{\link{multiblock_plots}}
and result functions: \code{\link{multiblock_results}}.
}
\description{
This is a wrapper for the \code{geigen::gsvd} function for computing GSVD.
}
\details{
GSVD is a generalisation of SVD to two variable-linked matrices where common loadings
and block-wise scores are estimated.
}
\examples{
data(potato)
X <- potato$Chemical

gsvd.pot <- gsvd(lapply(potato[3:4], t))

}
\references{
Van Loan, C. (1976) Generalizing the singular value decomposition. SIAM Journal on Numerical Analysis, 13, 76–83.
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
Common functions for computation and extraction of results and plotting are found in \code{\link{multiblock_results}} and \code{\link{multiblock_plots}}, respectively.
}
