% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpls.R
\name{lpls}
\alias{lpls}
\title{L-PLS regression}
\usage{
lpls(
  X1,
  X2,
  X3,
  ncomp = 2,
  doublecenter = TRUE,
  scale = c(FALSE, FALSE, FALSE),
  type = c("exo"),
  impute = FALSE,
  niter = 25,
  subsetX2 = NULL,
  subsetX3 = NULL,
  ...
)
}
\arguments{
\item{X1}{\code{matrix} of size IxN (middle matrix)}

\item{X2}{\code{matrix} of size IxJ (left matrix)}

\item{X3}{\code{matrix} of size KxN (top matrix)}

\item{ncomp}{number of L-PLS components}

\item{doublecenter}{\code{logical} indicating if centering should be done both ways for X1 (default=TRUE)}

\item{scale}{\code{logical vector} of length three indicating if each of the matrices should be autoscaled.}

\item{type}{\code{character} indicating type of L-PLS ("exo"=default, "exo_ort" or "endo")}

\item{impute}{\code{logical} indicating if SVD-based imputation of missing data is required.}

\item{niter}{\code{numeric} giving number of iterations in component extraction loop.}

\item{subsetX2}{\code{vector} defining optional sub-setting of X2 data.}

\item{subsetX3}{\code{vector} defining optional sub-setting of X3 data.}

\item{...}{Additional arguments, not used.}
}
\value{
An object of type \code{lpls} and \code{multiblock} containing all results from the L-PLS
analysis. The object type \code{lpls} is associated with functions for correlation loading plots,
prediction and cross-validation. The type \code{multiblock} is associated with the default functions
for result presentation (\code{\link{multiblock_results}}) and plotting (\code{\link{multiblock_plots}}).
}
\description{
Simultaneous decomposition of three blocks connected in an L pattern.
}
\details{
Two versions of L-PLS
are available: exo- and endo-L-PLS which assume an outward or inward relationship between the
main block X1 and the two other blocks X2 and X3.

The \code{exo_ort} algorithm returns orthogonal scores and should be chosen for visual
exploration in correlation loading plots. If exo-L-PLS with prediction is the main purpose
of the model then the non-orthogonal \code{exo} type L-PLS should be chosen for which the
predict function has prediction implemented.

\figure{LPLSsmall.png}{L-PLS diagram}
}
\examples{
# Simulate data set
sim <- lplsData(I = 30, N = 20, J = 5, K = 6, ncomp = 2)
X1  <- sim$X1; X2 <- sim$X2; X3 <- sim$X3
lp  <- lpls(X1,X2,X3) # exo-L-PLS

}
\references{
\itemize{
\item Martens, H., Anderssen, E., Flatberg, A.,Gidskehaug, L.H., Høy, M., Westad, F.,Thybo, A., and Martens, M. (2005). Regression of a data matrix on descriptors of both its rows and of its columns via latent variables: L-PLSR. Computational Statistics & Data Analysis, 48(1), 103 – 123.
\item Sæbø, S., Almøy, T., Flatberg, A., Aastveit, A.H., and Martens, H. (2008). LPLS-regression: a method for prediction and classification under the influence of background information on predictor variables. Chemometrics and Intelligent Laboratory Systems, 91, 121–132.
\item Sæbø, S., Martens, M. and Martens H. (2010) Three-block data modeling by endo- and exo-LPLS regression. In Handbook of Partial Least Squares: Concepts, Methods and Applications. Esposito Vinzi, V.; Chin, W.W.; Henseler, J.; Wang, H. (Eds.). Springer.
}
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
Functions for computation and extraction of results and plotting are found in \code{\link{lpls_results}}.
}
\author{
Solve Sæbø (adapted by Kristian Hovde Liland)
}
