\name{cocluster_RF}
\alias{cocluster_RF}
\title{
  Plot binary rule-based heatmaps
}
\description{
  \code{cocluster_RF} Plot clustering heatmaps showing which out-of-bag samples are predicted in the same class and in the same trees during the training process for the rule-based random forest classifier
}
\usage{
cocluster_RF(object,
            classifier,
            title         = "",
            top_anno      = c("ref","platform")[1],
            classes       = NULL,
            sam_order     = NULL,
            ref_col       = NULL,
            platform_col  = NULL,
            platforms_ord = NULL,
            show_platform = TRUE,
            cluster_cols  = FALSE,
            legend        = TRUE,
            anno_height   = 0.03,
            margin        = c(0, 5, 0, 5))
}
\arguments{
  \item{object}{
    data_object generated by ReadData function which was used in the training process.
  }
  \item{classifier}{
    classifier as a rule_based_RandomForest object, generated by train_RF function
  }
  \item{title}{
    Character input as a title for the whole heatmap. Default is "".
  }
    \item{top_anno}{
    Determine the top annotation level. Samples will be grouped based on the top_anno. Input can be one of two options: "ref", "platform". Default is "ref".
  }
    \item{classes}{
    Optional vector with the class names. Classes will determine which classes will be plotted and in which order. It is not recommended to use both "classes" and "platforms_ord" arguments together.
  }
  \item{sam_order}{
    Optional vector with the samples order in the heatmap.
  }
    \item{ref_col}{
    optional named vector determines the colors of classes for the reference labels. Default is NULL. Vector names should match with the ref labels.
  }
    \item{platform_col}{
    optional named vector determines the colors of platforms/study labels. Default is NULL. Vector names should match with the platforms/study labels.
  }
  \item{platforms_ord}{
    Optional vector with the platform/study names. This will determine which platform/study will be plotted and in which order. This will be used when top_anno="platform". It is not recommended to use both "classes" and "platforms_ord" arguments together.
  }
  \item{show_platform}{
    logical. Determines if the platform/study labels will be plotted or not. If the top_anno argument is "platform" then show_platform will be ignored.
  }
    \item{cluster_cols}{
    logical. samples will be grouped based on the class then will be Clustered in each class (i.e. not all samples in the cohort). If top_anno is "platform" then the rules from all classes are used to cluster the samples in each platform.
  }
  \item{legend}{
    logical. Determines if a legend will be plotted under the heatmap.
  }
  \item{anno_height}{
    Determines the height of the annotations. It is recommended not to go out of this range 0.01<height<0.1. Default is 0.03.
  }
  \item{margin}{
    Determines the margins of the heatmap. Default is c(0, 5, 0, 5).
  }
}

\value{
  returns a heatmap plot for the coclustered samples
}

\author{
  Nour-al-dain Marzouka <nour-al-dain.marzouka at med.lu.se>
}

\examples{
  # generate random data
Data <- matrix(runif(10000), nrow=100, ncol=80,
               dimnames = list(paste0("G",1:100), paste0("S",1:80)))

# generate random labels
L <- sample(x = c("A","B","C","D"), size = 80, replace = TRUE)

# generate random platform labels
P <- sample(c("P1","P2","P3"), size = 80, replace = TRUE)

# create data object
object <- ReadData(Data = Data,
                   Labels = L,
                   Platform = P,
                   verbose = FALSE)

# sort genes
genes_RF <- sort_genes_RF(data_object = object,
                           seed=123456, verbose = FALSE)

# creat and sort rules
rules_RF <- sort_rules_RF(data_object = object,
                           sorted_genes_RF = genes_RF,
                           genes_altogether = 10,
                           genes_one_vs_rest = 10,
                           seed=123456, verbose = FALSE)

# train the final model
# it is prefered to increase the number of trees and rules in case you have
# large number of samples and features
# for quick example, we have small number of trees and rules here
RF_classifier <- train_RF(data_object = object,
                          rules_altogether = 10,
                          rules_one_vs_rest = 10,
                          run_boruta = FALSE,
                          plot_boruta = FALSE,
                          num.trees = 300,
                          sorted_rules_RF = rules_RF,
                          verbose = FALSE)

# predict
results <- predict_RF(classifier = RF_classifier,
                       Data = object)

# not to run
# cocluster_RF(object = object,
#              classifier = RF_classifier,
#              title = "Test", cluster_cols = TRUE)
}
