% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multicmpests.R
\name{multicmpests}
\alias{multicmpests}
\title{Bivariate COM-Poisson Parameter Estimation}
\usage{
multicmpests(data, max = 100, startvalues = NULL)
}
\arguments{
\item{data}{A two-column dataset of counts.}

\item{max}{Truncation term for infinite summation associated with the Z function. See Sellers et al. (2016) for details.}

\item{startvalues}{A vector of starting values for maximum likelihood estimation. The values are read as follows: c(lambda, nu, p00, p10, p01, p11).
The default is c(1,1, 0.25, 0.25, 0.25, 0.25).}
}
\value{
\code{multicmpests} will return a list of four elements: $par (Parameter Estimates), $negll (Negative Log-Likelihood), $LRTbpd (Dispersion Test Statistic), and
    $pbpd (Dispersion Test P-Value).
}
\description{
\code{multicmpests} computes the maximum likelihood estimates of a bivariate COM-Poisson distribution (based on the model described in Sellers et al. (2016)) for given count data and conducts a test for significant data dispersion, relative to a bivariate Poisson model.
    The bivariate Poisson case is addressed via the bivpois package by Karlis and Ntzoufras (2009).
}
\examples{
    x1 <- c(3,2,5,4,1)
    x2 <- c(0,4,1,0,1)
    ex.data <- cbind(x1,x2)
    
    # starting close to the optimum for sake of run time
    multicmpests(ex.data, startvalues = c(12.5 , 1.7 , 0, 0.25, 0.75, 0)) 

}
\references{
Sellers KF, Morris DS, Balakrishnan N (2016) Bivariate Conway-Maxwell-Poisson Distribution: Formulation, Properties, and Inference, Journal of Multivariate Analysis 150:152-168.
    
    Karlis D., Ntzoufras I. (2009) bivpois: Bivariate Poisson Models Using the EM Algorithm, Version 0.50-3.1. http://cran.wustl.edu/web/packages/bivpois/index.html
}
