% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.mlpsa.R
\name{plot.mlpsa}
\alias{plot.mlpsa}
\title{Plots the results of a multilevel propensity score model.}
\usage{
\method{plot}{mlpsa}(x, ratio = c(1, 2), plotExtra = NULL, ...)
}
\arguments{
\item{x}{the results of \code{\link{mlpsa}}.}

\item{ratio}{the ratio of the size of the distribution plots (left and bottom)
to the circular plot.}

\item{plotExtra}{a plot to place in the lower left corner.}

\item{...}{parameters passed to \code{\link{mlpsa.circ.plot}} and 
\code{\link{mlpsa.distribution.plot}}}
}
\description{
The plot created uses the \code{ggplot2} framework. As such, additional modifications
can be made. This plot is an extension of the \code{circ.psa} function in the
\code{PSAgraphics} package for multilevel models.
}
\examples{
\dontrun{
require(multilevelPSA)
require(party)
data(pisana)
data(pisa.colnames)
data(pisa.psa.cols)
mlctree = mlpsa.ctree(pisana[,c('CNT','PUBPRIV',pisa.psa.cols)], formula=PUBPRIV ~ ., level2='CNT')
student.party = getStrata(mlctree, pisana, level2='CNT')
student.party$mathscore = apply(student.party[,paste0('PV', 1:5, 'MATH')], 1, sum) / 5
results.psa.math = mlpsa(response=student.party$mathscore, 
       treatment=student.party$PUBPRIV, 
       strata=student.party$strata, 
       level2=student.party$CNT, minN=5)
plot(results.psa.math)
}
}
