% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/CJS.R
\name{multimodelCJS}
\alias{multimodelCJS}
\title{Multimodel inference for 'multimark' open population survival models}
\usage{
multimodelCJS(mms, modlist, modprior = rep(1/length(modlist),
  length(modlist)), monparms = "phi", miter = NULL, mburnin = 0,
  mthin = 1, M1 = NULL, pbetapropsd = 1, zppropsd = NULL,
  phibetapropsd = 1, zphipropsd = NULL, sigppropshape = 1,
  sigppropscale = 0.01, sigphipropshape = 1, sigphipropscale = 0.01,
  printlog = FALSE)
}
\arguments{
\item{mms}{An object of class \code{multimarksetup}. See \code{\link{multimarksetup-class}}.}

\item{modlist}{A list of individual model output lists returned by \code{\link{multimarkCJS}}. The models must have the same number of chains and MCMC iterations.}

\item{modprior}{Vector of length \code{length(modlist)} containing prior model probabilities. Default is \code{modprior = rep(1/length(modlist), length(modlist))}.}

\item{monparms}{Parameters to monitor. Only parameters common to all models can be monitored (e.g., "\code{pbeta[(Intercept)]}", "\code{phibeta[(Intercept)]}", "\code{psi}"), but derived survival ("\code{phi}") and capture ("\code{p}") probabilities can also be monitored. Default is \code{monparms = "phi"}.}

\item{miter}{The number of RJMCMC iterations per chain. If \code{NULL}, then the number of MCMC iterations for each individual model chain is used.}

\item{mburnin}{Number of burn-in iterations (\code{0 <= mburnin < miter}).}

\item{mthin}{Thinning interval for monitored parameters.}

\item{M1}{Integer vector indicating the initial model for each chain, where \code{M1_j=i} initializes the RJMCMC algorithm for chain j in the model corresponding to \code{modlist[[i]]} for i=1,...,  \code{length(modlist)}. If \code{NULL}, the algorithm for all chains is initialized in the most general model. Default is \code{M1=NULL}.}

\item{pbetapropsd}{Scaler specifying the standard deviation of the Normal(0, pbetapropsd) proposal distribution for "\code{pbeta}"  parameters. Default is \code{pbetapropsd=1}. See Barker & Link (2013) for more details.}

\item{zppropsd}{Scaler specifying the standard deviation of the Normal(0, zppropsd) proposal distribution for "\code{zp}"  parameters. Only applies if at least one (but not all) model(s) include individual hetergeneity in detection probability. If \code{NULL}, zppropsd = sqrt(sigma2_zp) is used. Default is \code{zppropsd=NULL}. See Barker & Link (2013) for more details.}

\item{phibetapropsd}{Scaler specifying the standard deviation of the Normal(0, phibetapropsd) proposal distribution for "\code{phibeta}"  parameters. Default is \code{phibetapropsd=1}. See Barker & Link (2013) for more details.}

\item{zphipropsd}{Scaler specifying the standard deviation of the Normal(0, zphipropsd) proposal distribution for "\code{zphi}"  parameters. Only applies if at least one (but not all) model(s) include individual hetergeneity in survival probability. If \code{NULL}, zphipropsd = sqrt(sigma2_zphi) is used. Default is \code{zphipropsd=NULL}. See Barker & Link (2013) for more details.}

\item{sigppropshape}{Scaler specifying the shape parameter of the invGamma(shape = sigppropshape, scale = sigppropscale) proposal distribution for "\code{sigma2_zp}". Only applies if at least one (but not all) model(s) include individual hetergeneity in detection probability. Default is \code{sigppropshape=1}. See Barker & Link (2013) for more details.}

\item{sigppropscale}{Scaler specifying the scale parameter of the invGamma(shape = sigppropshape, scale = sigppropscale) proposal distribution for "\code{sigma2_zp}". Only applies if at least one (but not all) model(s) include individual hetergeneity in detection probability. Default is \code{sigppropscale=0.01}. See Barker & Link (2013) for more details.}

\item{sigphipropshape}{Scaler specifying the shape parameter of the invGamma(shape = sigphipropshape, scale = sigphipropscale) proposal distribution for "\code{sigma2_zphi}". Only applies if at least one (but not all) model(s) include individual hetergeneity in survival probability. Default is \code{sigphipropshape=1}. See Barker & Link (2013) for more details.}

\item{sigphipropscale}{Scaler specifying the scale parameter of the invGamma(shape = sigphipropshape, scale = sigphipropscale) proposal distribution for "\code{sigma_zphi}". Only applies if at least one (but not all) model(s) include individual hetergeneity in survival probability. Default is \code{sigphipropscale=0.01}. See Barker & Link (2013) for more details.}

\item{printlog}{Logical indicating whether to print the progress of chains and any errors to a log file in the working directory. Ignored when \code{nchains=1}. Updates are printed to log file as 1\% increments of \code{iter} of each chain are completed. With >1 chains, setting \code{printlog=TRUE} is probably most useful for Windows users because progress and errors are automatically printed to the R console for "Unix-like" machines (i.e., Mac and Linux) when \code{printlog=FALSE}. Default is \code{printlog=FALSE}.}
}
\value{
A list containing the following:
\item{rjmcmc}{Reversible jump Markov chain Monte Carlo object of class \code{\link[coda]{mcmc.list}}. Includes RJMCMC output for monitored parameters and the current model at each iteration ("\code{M}").}
\item{pos.prob}{A list of calculated posterior model probabilities for each chain, including the overall posterior model probabilities across all chains.}
}
\description{
This function performs Bayesian multimodel inference for a set of 'multimark' open population survival (i.e., Cormack-Jolly-Seber) models using the reversible jump Markov chain Monte Carlo (RJMCMC) algorithm proposed by Barker & Link (2013).
}
\details{
Note that setting \code{parms="all"} is required when fitting individual \code{\link{multimarkCJS}} models to be included in \code{modlist}.
}
\examples{
\dontshow{
setup<-processdata(bobcat)
test.dot<-multimarkCJS(mms=setup,parms="all",iter=10,burnin=0)
test<-multimodelCJS(mms=setup,modlist=list(mod1=test.dot,mod2=test.dot))
set.seed(10)
}
\donttest{
# This example is excluded from testing to reduce package check time
# Example uses unrealistically low values for nchain, iter, and burnin

#Generate object of class "multimarksetup" from simulated data
data_type = "always"
noccas <- 5
phibetaTime <- seq(2,0,length=noccas-1) # declining trend in survival
data <- simdataCJS(noccas=5,phibeta=phibetaTime,data.type=data_type)
setup <- processdata(data$Enc.Mat,data.type=data_type)

#Run two parallel chains using the default model. Note parms="all".
sim.pdot.phidot <- multimarkCJS(mms=setup,parms="all")

#Run two parallel chains with temporal trend for phi. Note parms="all".
sim.pdot.phiTime <- multimarkCJS(mms=setup,mod.phi=~Time,parms="all")

#Perform RJMCMC using defaults
modlist <- list(mod1=sim.pdot.phidot,mod2=sim.pdot.phiTime)
sim.M <- multimodelCJS(mms=setup,modlist=modlist)

#Posterior model probabilities
sim.M$pos.prob

#multimodel posterior summary for survival (display first cohort only)
summary(sim.M$rjmcmc[,paste0("phi[1,",1:(noccas-1),"]")])}
}
\author{
Brett T. McClintock
}
\references{
Barker, R. J. and Link. W. A. 2013. Bayesian multimodel inference by RJMCMC: a Gibbs sampling approach. The American Statistician 67: 150-156.
}
\seealso{
\code{\link{multimarkCJS}}, \code{\link{processdata}}
}

