% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_shape_multilevel.R
\name{set_shape_multilevel}
\alias{set_shape_multilevel}
\title{Set shapes for levels of a multilevel network}
\usage{
set_shape_multilevel(x, shape.true = "square", shape.false = "circle")
}
\arguments{
\item{x}{a graph object. Must be a multilevel network.}

\item{shape.true}{a character. The shape to be chosen for the higher
level (attribute \code{type} set to \code{TRUE}).}

\item{shape.false}{a character. The shape to be chosen for the lower
level (attribute \code{type} set to \code{FALSE}).}
}
\value{
A graph object. A multilevel network with an added \code{shape}
  vertex attribute vector.
}
\description{
Set vertices shapes for a multilevel network.
  Default set to "square" (higher level) and "circle" (lower level).
}
\examples{
# Check whether a graph is multilevel
is_multilevel(linked_sim)

# Set the shapes for each level
linked_sim <- set_shape_multilevel(linked_sim)



}
\author{
Neylson Crepalde, \email{neylsoncrepalde@gmail.com}
}
