% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ops.R
\name{nsa}
\alias{nsa}
\title{No strings attached mode}
\usage{
nsa(.self, enabled = TRUE)
}
\arguments{
\item{.self}{Data frame}

\item{enabled}{TRUE to enable, FALSE to disable. Defaults to TRUE.}
}
\value{
Data frame
}
\description{
This function may be used to set or unset whether a data frame is in no
strings attached mode, potentially speeding up various operations.
}
\details{
This function will place a data frame in no strings attached mode, which
disables translation of character values to and from numeric representation.
This allows for much faster calculations.
}
\examples{
\donttest{
dat <- Multiplyr (G=rep(c("A", "B", "C", "D"), length.out=100))
dat \%>\% nsa () \%>\% mutate (G=max(G)) \%>\% nsa(FALSE)
dat \%>\% shutdown()
}
}
\seealso{
Other data manipulations: \code{\link{mutate}},
  \code{\link{mutate_}}; \code{\link{reduce}},
  \code{\link{reduce_}}; \code{\link{summarise}},
  \code{\link{summarise_}}; \code{\link{transmute}},
  \code{\link{transmute_}}; \code{\link{within_group}};
  \code{\link{within_node}}
}

