% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unpack-multiverse.R
\name{reveal_corrs}
\alias{reveal_corrs}
\title{Reveal a set of multiverse correlations}
\usage{
reveal_corrs(.descriptives, .which, .unpack_specs = "no")
}
\arguments{
\item{.descriptives}{a descriptive multiverse list-column \code{tibble}
produced by \code{\link{run_descriptives}}.}

\item{.which}{the specific name of the correlations requested}

\item{.unpack_specs}{character, options are \code{"no"}, \code{"wide"}, or
\code{"long"}. \code{"no"} (default) keeps specifications in a list column,
\code{wide} unnests specifications with each specification category as a
column. \code{"long"} unnests specifications and stacks them into long
format, which stacks specifications into a \code{decision_set} and
\code{alternatives} columns. This is mainly useful for plotting.}
}
\value{
an unnested set of correlations per decision from the
multiverse.
}
\description{
Reveal a set of multiverse correlations
}
\examples{

library(tidyverse)
library(multitool)

# create some data
the_data <-
  data.frame(
    id  = 1:500,
    iv1 = rnorm(500),
    iv2 = rnorm(500),
    iv3 = rnorm(500),
    mod = rnorm(500),
    dv1 = rnorm(500),
    dv2 = rnorm(500),
    include1 = rbinom(500, size = 1, prob = .1),
    include2 = sample(1:3, size = 500, replace = TRUE),
    include3 = rnorm(500)
  )

# create a pipeline blueprint
full_pipeline <-
  the_data |>
  add_filters(
    include1 == 0,
    include2 != 3,
    include2 != 2,
    include3 > -2.5,
    include3 < 2.5,
    between(include3, -2.5, 2.5)
  ) |>
  add_variables(var_group = "ivs", iv1, iv2, iv3) |>
  add_variables(var_group = "dvs", dv1, dv2) |>
  add_correlations("predictors", starts_with("iv")) |>
  add_summary_stats("iv_stats", starts_with("iv"), c("mean", "sd")) |>
  add_reliabilities("vio_scale", starts_with("iv")) |>
  add_model("linear model", lm({dvs} ~ {ivs} * mod))

my_descriptives <- run_descriptives(full_pipeline)

my_descriptives |>
  reveal_corrs(predictors_rs)
}
