% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoA.R
\name{CoA}
\alias{CoA}
\title{Centre of activity}
\usage{
CoA(x)
}
\arguments{
\item{x}{A time series  (numeric)}
}
\value{
The centre of activity of the time series, calculated with
circular statistics
}
\description{
Centre of activity
}
\examples{
# Number of users connected to the Internet through a server every minute
ts <- datasets::WWWusage[1:80]

# Calculate CoA
ts_CoA <- CoA(ts)

# Plot
plot(ts, ty = "l", xlab = "Time", ylab = "Number of users")
graphics::abline(v = ts_CoA, lwd = 2, lty = 2)
}
\references{
Martino, G. et al.
Locomotor patterns in cerebellar ataxia.
J. Neurophysiol. 112, 2810–2821 (2014).
}
