% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtEMG.R
\name{filtEMG}
\alias{filtEMG}
\title{To filter raw EMG}
\usage{
filtEMG(
  x,
  demean = TRUE,
  rectif = "fullwave",
  HPf = 50,
  HPo = 4,
  LPf = 20,
  LPo = 4,
  min_sub = TRUE,
  ampl_norm = TRUE
)
}
\arguments{
\item{x}{Object of class \code{EMG} with elements \code{cycles} and \code{emg}}

\item{demean}{Logical: should EMG be demeaned?}

\item{rectif}{Rectification type: "fullwave", halfwave" or "none"}

\item{HPf}{High-pass filter cut-off frequency, use 0 to exclude high-pass filtering}

\item{HPo}{High-pass filter order}

\item{LPf}{Low-pass filter cut-off frequency, use 0 to exclude Low-pass filtering}

\item{LPo}{Low-pass filter order}

\item{min_sub}{Logical: should the minimum be subtracted?}

\item{ampl_norm}{Logical: should amplitude be normalised?}
}
\value{
Object of class \code{EMG} with elements:\cr
\itemize{
\item \code{cycles} data frame containing cycle timings, with as many columns as many cycle subdivisions are wanted\cr
\item \code{emg} data frame containing filtered EMG data in columns, first column is time
}
}
\description{
To filter raw EMG
}
\details{
Lists in the correct format can be created with the function \code{rawdata()}.
The first column of each \code{emg} element must be time in the same units as those
used for \code{cycles} (e.g., [s] or [ms]).
}
\examples{
# Load some data
data("RAW_DATA")
# Filter raw EMG
filtered_EMG <- pbapply::pblapply(
  RAW_DATA,
  function(x) {
    filtEMG(x,
      HPf = 50,
      HPo = 4,
      LPf = 20,
      LPo = 4
    )
  }
)
}
\references{
Santuz, A., Ekizos, A., Janshen, L., Baltzopoulos, V. & Arampatzis, A.
On the Methodological Implications of Extracting Muscle Synergies from Human Locomotion.
Int. J. Neural Syst. 27, 1750007 (2017).
}
