% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals_and_scales.R
\name{meantone_fifth}
\alias{meantone_fifth}
\title{Define a tempered fifth for various meantone scales}
\usage{
meantone_fifth(frac = 1/4)
}
\arguments{
\item{frac}{The fraction of a syntonic comma that the fifth should
be tempered by. Defaults to \code{1/4}. Numeric.}
}
\value{
Single numeric value of the tempered fifth
measured in 12edo semitones.
}
\description{
Creates an interval that approximates a pure 3:2 fifth
which has been tempered smaller by some fraction of a syntonic comma,
making it easy to construct diatonic meantone scales. The default
is to create a quarter-comma meantone fifth (i.e. about 697 cents).
}
\examples{
zarlino_fifth <- meantone_fifth(2/7)
zarlino_diatonic <- sort((0:6 * zarlino_fifth) \%\% 12)
print(zarlino_diatonic)

fifth_in_19edo <- convert(11, 19, 12)
meantone_fifth(1/3) - fifth_in_19edo
}
