/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.af.jhlir.call.RObj;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.Method;
import org.mutoss.MethodSorter;
import org.mutoss.MuTossControl;
import org.mutoss.gui.MuTossGUI;
import org.mutoss.gui.dialogs.MethodDialog;

public class MethodHandler {
    private static final Log logger = LogFactory.getLog(MethodHandler.class);
    static List<String> methodNames;
    static List<Method> methods;
    static MethodHandler mh;

    public static void updateMethods() {
        mh = new MethodHandler();
    }

    public static MethodHandler getMethodHandler() {
        if (mh == null) {
            mh = new MethodHandler();
        }
        return mh;
    }

    protected MethodHandler() {
        MuTossControl.getInstance();
        methodNames = Arrays.asList(MuTossControl.getR().eval("c(apropos(\"^mutoss\"), ls( asNamespace( \"mutoss\" ), pattern=\"mutoss.*\", all = TRUE ))").asRChar().getData());
        methods = new Vector<Method>();
        for (String methodname : methodNames) {
            RObj result;
            if (MuTossControl.getR().eval("class(try(class(mutoss:::" + methodname + "())==\"MutossMethod\",silent=TRUE))==\"try-error\"").asRLogical().getData()[0] || (result = MuTossControl.getR().eval("class(mutoss:::" + methodname + "())==\"MutossMethod\"")) == null || !result.asRLogical().getData()[0]) continue;
            Method method = new Method(methodname);
            methods.add(method);
            logger.info((Object)("Added method \"" + method.label + "\" from " + method.name + "."));
            Collections.sort(methods, new MethodSorter());
        }
    }

    public List<Method> getAdjustedPValueMethods() {
        Vector<Method> pAdjMethods = new Vector<Method>();
        for (Method m : methods) {
            if (!m.isApplicable() || !m.returnsAdjPValues()) continue;
            pAdjMethods.add(m);
        }
        return pAdjMethods;
    }

    public static Method getMethod(String method) {
        for (Method m : methods) {
            if (!m.name.equals(method)) continue;
            return m;
        }
        return null;
    }

    public void apply(String methodname) {
        Method method = MethodHandler.getMethod(methodname);
        new MethodDialog(MuTossGUI.getGUI(), method);
    }

    public List<Method> getRejectedMethods() {
        Vector<Method> pAdjMethods = new Vector<Method>();
        for (Method m : methods) {
            if (!m.isApplicable() || !m.returnsRejected()) continue;
            pAdjMethods.add(m);
        }
        return pAdjMethods;
    }

    public List<Method> getPValueMethods() {
        Vector<Method> pMethods = new Vector<Method>();
        for (Method m : methods) {
            if (!m.isApplicable() || !m.returnsPValues()) continue;
            pMethods.add(m);
        }
        return pMethods;
    }

    public List<Method> getCIMethods() {
        Vector<Method> pMethods = new Vector<Method>();
        for (Method m : methods) {
            if (!m.isApplicable() || !m.returnsCI()) continue;
            pMethods.add(m);
        }
        return pMethods;
    }

    static {
        mh = null;
    }
}

