/*
 * Decompiled with CFR 0.152.
 */
package junit;

import java.util.List;
import junit.MyTestCase;
import org.af.jhlir.call.RCallServices;
import org.af.jhlir.call.RFactor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RFactor_Test
extends MyTestCase {
    private RFactor rFact1;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rFact1 = this.getRServices().eval("as.factor(c(\"b\", NA,\"b\", \"a\"))").asRFactor();
    }

    @Test
    public void testAt() {
        Assert.assertEquals((long)this.rFact1.getLength(), (long)4L);
        Assert.assertEquals(this.rFact1.get(0), (Object)"b");
        Assert.assertFalse((boolean)this.rFact1.isNA(0));
        Assert.assertEquals(this.rFact1.get(1), (Object)RCallServices.NA_FACTOR);
        Assert.assertTrue((boolean)this.rFact1.isNA(1));
        Assert.assertEquals(this.rFact1.get(2), (Object)"b");
        Assert.assertFalse((boolean)this.rFact1.isNA(2));
        Assert.assertEquals(this.rFact1.get(3), (Object)"a");
        Assert.assertFalse((boolean)this.rFact1.isNA(3));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void outOfBounds() {
        this.rFact1.get(-1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void outOfBounds2() {
        this.rFact1.get(4);
    }

    @Test
    public void testGetDataAsObjArr() {
        String[] xs = this.rFact1.getDataAsObjArr();
        Assert.assertEquals((long)xs.length, (long)4L);
        Assert.assertEquals((Object)xs[0], (Object)"b");
        Assert.assertEquals((Object)xs[1], (Object)RCallServices.NA_FACTOR);
        Assert.assertEquals((Object)xs[2], (Object)"b");
        Assert.assertEquals((Object)xs[3], (Object)"a");
    }

    @Test
    public void testAsList() {
        List<String> xs = this.rFact1.getDataAsList();
        Assert.assertEquals((long)xs.size(), (long)4L);
        Assert.assertEquals((Object)xs.get(0), (Object)"b");
        Assert.assertEquals((Object)xs.get(1), (Object)RCallServices.NA_FACTOR);
        Assert.assertEquals((Object)xs.get(2), (Object)"b");
        Assert.assertEquals((Object)xs.get(3), (Object)"a");
    }
}

