/*
 * Decompiled with CFR 0.152.
 */
package junit;

import java.util.List;
import junit.RVector_Test;
import org.af.jhlir.call.RCallServices;
import org.af.jhlir.call.RNumeric;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class RNumeric_Test
extends RVector_Test {
    private RNumeric rNumW1;
    private RNumeric rNumW2;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.getRServices().assign("rnum1", "c(1.1, 5, NA, 3, 10.1, NA)");
        this.getRServices().assign("rnum2", "c(1.2, 2, 3)");
        this.rNumW1 = this.getRServices().eval("rnum1").asRNumeric();
        this.rNumW2 = this.getRServices().eval("rnum2").asRNumeric();
        this.registerVecs(this.rNumW1, this.rNumW2);
    }

    @Test
    public void testAt() {
        double[] xs = this.rNumW1.getData();
        Assert.assertEquals((long)this.rNumW1.getLength(), (long)6L);
        Assert.assertEquals(this.rNumW1.get(0), (Object)1.1);
        Assert.assertFalse((boolean)this.rNumW1.isNA(0));
        Assert.assertEquals(this.rNumW1.get(1), (Object)5.0);
        Assert.assertFalse((boolean)this.rNumW1.isNA(1));
        Assert.assertEquals(this.rNumW1.get(2), (Object)RCallServices.NA_RNUMERIC);
        Assert.assertTrue((boolean)this.rNumW1.isNA(2));
        Assert.assertEquals(this.rNumW1.get(3), (Object)3.0);
        Assert.assertFalse((boolean)this.rNumW1.isNA(3));
        Assert.assertEquals(this.rNumW1.get(4), (Object)10.1);
        Assert.assertFalse((boolean)this.rNumW1.isNA(4));
        Assert.assertEquals(this.rNumW1.get(5), (Object)RCallServices.NA_RNUMERIC);
        Assert.assertTrue((boolean)this.rNumW1.isNA(5));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void outOfBounds() {
        this.rNumW1.get(-1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void outOfBounds2() {
        this.rNumW1.get(6);
    }

    @Test
    public void testGetDataAsObjArr() {
        Double[] xs = this.rNumW1.getDataAsObjArr();
        Assert.assertEquals((long)xs.length, (long)6L);
        Assert.assertEquals((Object)xs[0], (Object)1.1);
        Assert.assertEquals((Object)xs[1], (Object)5.0);
        Assert.assertEquals((Object)xs[2], (Object)RCallServices.NA_RNUMERIC);
        Assert.assertEquals((Object)xs[3], (Object)3.0);
        Assert.assertEquals((Object)xs[4], (Object)10.1);
        Assert.assertEquals((Object)xs[5], (Object)RCallServices.NA_RNUMERIC);
    }

    @Test
    public void testAsList() {
        List<Double> xs = this.rNumW1.getDataAsList();
        Assert.assertEquals((long)xs.size(), (long)6L);
        Assert.assertEquals((Object)xs.get(0), (Object)1.1);
        Assert.assertEquals((Object)xs.get(1), (Object)5.0);
        Assert.assertEquals((Object)xs.get(2), (Object)RCallServices.NA_RNUMERIC);
        Assert.assertEquals((Object)xs.get(3), (Object)3.0);
        Assert.assertEquals((Object)xs.get(4), (Object)10.1);
        Assert.assertEquals((Object)xs.get(5), (Object)RCallServices.NA_RNUMERIC);
    }
}

