/*
 * Decompiled with CFR 0.152.
 */
package org.af.jhlir.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.af.jhlir.packages.CantFindPackageException;
import org.af.jhlir.packages.RPackage;
import org.af.jhlir.tools.RCmdBatchException;

public class RCmdBatch {
    public static final String[] R_ARGS = new String[]{"--vanilla", "--slave"};
    protected File rHome;
    protected File tempDir;
    protected String libPaths;
    protected String rVersion;

    public RCmdBatch(File rHome) {
        this(rHome.getAbsolutePath());
    }

    public RCmdBatch(String rHome) {
        this.rHome = new File(rHome);
        this.tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (rHome == null || rHome.trim().equals("")) {
            String s = "Empty R_Home passed to RCmdBatch! It was: " + rHome;
            throw new RuntimeException(s);
        }
    }

    public List<String> exec(List<String> input) throws RCmdBatchException {
        ArrayList<String> output = new ArrayList<String>();
        String fn = "r_batch_" + Calendar.getInstance().getTime().getTime();
        File batchFile = new File(this.tempDir, fn);
        try {
            this.makeRBatchScript(batchFile, input);
        }
        catch (FileNotFoundException e) {
            throw new RCmdBatchException("", e);
        }
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.getRExePath().getAbsolutePath());
        commands.add("CMD");
        commands.add("BATCH");
        commands.add("--no-timing");
        for (String arg : R_ARGS) {
            commands.add(arg);
        }
        commands.add(batchFile.getAbsolutePath());
        ProcessBuilder pb = new ProcessBuilder(commands);
        pb.directory(this.tempDir);
        Process ps = null;
        try {
            ps = pb.start();
            this.logProcessOutput(ps);
        }
        catch (IOException e) {
            throw new RCmdBatchException("", e);
        }
        int exitCode = 0;
        try {
            exitCode = ps.waitFor();
        }
        catch (InterruptedException e) {
            throw new RCmdBatchException("", e);
        }
        File outputFile = new File(this.tempDir, fn + ".Rout");
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(outputFile));
        }
        catch (FileNotFoundException e) {
            throw new RCmdBatchException("", e);
        }
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                output.add(line);
            }
        }
        catch (IOException e) {
            throw new RCmdBatchException("sdf: ", e);
        }
        if (exitCode != 0) {
            String s = "R CMD BATCH exited abnormally with code: " + exitCode + "\n";
            s = s + "Batch file was:\n" + input.toString() + "\n";
            s = s + "R Output was:\n" + ((Object)output).toString();
            throw new RCmdBatchException(s);
        }
        return output;
    }

    protected void makeRBatchScript(File target, List<String> commands) throws FileNotFoundException {
        PrintStream p = new PrintStream(new FileOutputStream(target));
        for (String c : commands) {
            p.println(c);
        }
        p.close();
    }

    public String retrieveInfo(List<String> input, String var) throws RCmdBatchException {
        return this.retrieveInfo(input, Arrays.asList(var)).get(var);
    }

    public Map<String, String> retrieveInfo(List<String> input, List<String> vars) throws RCmdBatchException {
        HashMap<String, String> res = new HashMap<String, String>();
        ArrayList<String> is = new ArrayList<String>();
        for (String v : vars) {
            is.add(v + "<- ''");
        }
        is.addAll(input);
        for (String v : vars) {
            is.add("print(paste(\"<var>\"," + v + "))");
        }
        List<String> os = this.exec(is);
        for (int i = 0; i < vars.size(); ++i) {
            String s = os.get(os.size() - 1 - i);
            int n1 = s.indexOf("<var>");
            int n2 = s.lastIndexOf("\"");
            res.put(vars.get(vars.size() - 1 - i), s.substring(n1 + 6, n2));
        }
        return res;
    }

    protected File getRExePath() {
        return new File(new File(this.rHome, "bin"), "R");
    }

    public RPackage getInstalledPackInfo(String pack) throws RCmdBatchException {
        List<String> is = Arrays.asList("found <- require('" + pack + "')", "if (found) {", "desc <- packageDescription('" + pack + "')", "title <- desc$Title", "ver <- desc$Version", "lp <- dirname(dirname(dirname(attr(desc, 'file'))))", "}");
        Map<String, String> m = this.retrieveInfo(is, Arrays.asList("title", "lp", "ver"));
        if (m.get("lp").trim().equals("")) {
            return null;
        }
        return new RPackage(pack, m.get("title"), new File(m.get("lp")), m.get("ver"));
    }

    public boolean isInstalled(String pack) throws RCmdBatchException {
        return this.getInstalledPackInfo(pack) == null;
    }

    public List<String> getInstalledPackages() throws RCmdBatchException {
        List<String> is = Arrays.asList("ps <- installed.packages(noCache=TRUE)[,'Package']", "names(ps) <- NULL", "ps <- paste(ps, collapse=';')");
        String ps = this.retrieveInfo(is, "ps");
        String[] names = ps.split(";");
        return Arrays.asList(names);
    }

    private RPackage installPackage(String p, String repos, File where) throws CantFindPackageException, RCmdBatchException {
        List<String> is = Arrays.asList("install.packages('" + p + "'" + ", repos='" + repos + "'" + (where == null ? "" : ", destdir='" + where.getAbsolutePath().replace("\\", "/") + "', lib='" + where.getAbsolutePath().replace("\\", "/") + "'") + ")");
        List<String> os = this.exec(is);
        for (String s : os) {
            if (!s.contains(p) || !s.contains("is not available")) continue;
            throw new CantFindPackageException("Can't find package " + p + " on repository " + repos + "!");
        }
        return this.getInstalledPackInfo(p);
    }

    private RPackage installPackage(String pack, String repos) throws CantFindPackageException, RCmdBatchException {
        return this.installPackage(pack, repos, null);
    }

    public RPackage installCranPackage(String pack) throws CantFindPackageException, RCmdBatchException {
        return this.installPackage(pack, "http://cran.r-project.org");
    }

    public RPackage installCranPackage(String pack, File where) throws CantFindPackageException, RCmdBatchException {
        return this.installPackage(pack, "http://cran.r-project.org", where);
    }

    public RPackage installRForgePackage(String pack) throws CantFindPackageException, RCmdBatchException {
        return this.installPackage(pack, "http://R-Forge.R-project.org");
    }

    public RPackage installRForgePackage(String pack, File where) throws CantFindPackageException, RCmdBatchException {
        return this.installPackage(pack, "http://R-Forge.R-project.org", where);
    }

    private void logProcessOutput(Process ps) throws IOException {
        String line;
        BufferedReader is = new BufferedReader(new InputStreamReader(ps.getInputStream()));
        while ((line = is.readLine()) != null) {
        }
        is = new BufferedReader(new InputStreamReader(ps.getErrorStream()));
        while ((line = is.readLine()) != null) {
        }
    }

    public void retrieveRInfo() throws RCmdBatchException {
        ArrayList<String> input = new ArrayList<String>();
        input.add("lp <-  paste(.libPaths(),collapse=.Platform$path.sep)");
        input.add("ver <-  paste(sessionInfo()$R.version$major, sessionInfo()$R.version$minor, sep=\".\")");
        Map<String, String> m = this.retrieveInfo(input, Arrays.asList("lp", "ver"));
        this.libPaths = m.get("lp");
        this.rVersion = m.get("ver");
    }

    public String getRVersion() {
        return this.rVersion;
    }

    public String getLibPaths() {
        return this.libPaths;
    }
}

