/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.dialogs.model;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import org.af.jhlir.call.RDataFrame;
import org.mutoss.MuTossControl;
import org.mutoss.gui.dialogs.StatMethodDialog;
import org.mutoss.gui.widgets.AnalysisDialogFactory;
import org.mutoss.gui.widgets.CovariatesSL;

public class OneEndpointLM
extends StatMethodDialog
implements ActionListener {
    private JComboBox cbResponse;
    private CovariatesSL slCovariates;

    public OneEndpointLM(JFrame frame, RDataFrame df) {
        super(frame, "Single Variate Linear Mode", df);
        this.cbResponse = AnalysisDialogFactory.makeNumericVarBox(df);
        this.slCovariates = AnalysisDialogFactory.makeCovariatesSL(df);
        Object[] labels = new String[]{"Response", "Covariates"};
        Component[] comps = new Component[]{this.cbResponse, this.slCovariates};
        this.setContent(labels, comps);
        this.setup();
    }

    protected void checkConstraints() {
        this.requiresNumVar();
    }

    protected void onOk() {
        String resp = this.cbResponse.getSelectedItem().toString();
        List covarName = this.slCovariates.getSelectedStrings();
        String rhs = (String)covarName.get(0);
        for (int i = 1; i < covarName.size(); ++i) {
            rhs = rhs + "+" + (String)covarName.get(i);
        }
        MuTossControl.getR().eval(".MuTossTMPModel <- lm(" + resp + "~" + rhs + ", data=" + MuTossControl.getObj().getObjName() + "@data)");
        MuTossControl.getObj().setModel(".MuTossTMPModel");
        this.dispose();
    }
}

