/*
 * Decompiled with CFR 0.152.
 */
package af.statguitoolkit.gui.datatable;

import af.statguitoolkit.gui.datatable.DataTable;
import af.statguitoolkit.gui.datatable.DataTableModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.table.JTableHeader;
import org.af.commons.Localizer;
import org.af.commons.widgets.MyJPopupMenu;
import org.af.jhlir.call.RChar;
import org.af.jhlir.call.RFactor;
import org.af.jhlir.call.RInteger;
import org.af.jhlir.call.RLogical;
import org.af.jhlir.call.RNumeric;

public class HeaderPopup
extends MyJPopupMenu
implements ActionListener {
    private DataTable dataTable;
    private JTableHeader header;
    private DataTableModel model;

    public HeaderPopup(DataTable dataTable) {
        super(new String[]{Localizer.getInstance().getString("SGTK_DATATABLE_HEADERPOPUP_RENAME"), Localizer.getInstance().getString("SGTK_DATATABLE_HEADERPOPUP_SELECTTYPE")}, new String[]{"rename", "change_type"});
        this.addActionListener(this);
        this.dataTable = dataTable;
        this.header = dataTable.getTableHeader();
        this.model = dataTable.getModel();
    }

    public void actionPerformed(ActionEvent e) {
        int col = this.dataTable.getTableHeader().columnAtPoint(this.getInvocationPoint());
        if (col >= 0 && col < this.header.getColumnModel().getColumnCount()) {
            String var = this.dataTable.getColumnVar(col);
            if (e.getActionCommand().equals("rename") || e.getActionCommand().equals("change_type")) {
                // empty if block
            }
        }
    }

    private Class typeStringToClass(String type) {
        if (type.equals("Numeric")) {
            return RNumeric.class;
        }
        if (type.equals("Integer")) {
            return RInteger.class;
        }
        if (type.equals("Factor")) {
            return RFactor.class;
        }
        if (type.equals("Character")) {
            return RChar.class;
        }
        if (type.equals("Logical")) {
            return RLogical.class;
        }
        return null;
    }

    private Class[] typeStringsToClass(String[] types) {
        Class[] result = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = this.typeStringToClass(types[i]);
        }
        return result;
    }
}

