% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvord.R
\name{multord2}
\alias{multord2}
\title{Multivariate Ordinal Regression Models with Subject Specific Covariates}
\usage{
multord2(formula, error.structure = corGeneral(~1), data, link = c("probit",
  "logit"), coef.constraints = NULL, coef.values = NULL,
  threshold.constraints = NULL, threshold.values = NULL, weights = NULL,
  se = TRUE, start.values = NULL, solver = "BFGS", control = list(maxit
  = 2e+05, trace = 1, kkt = FALSE))
}
\arguments{
\item{formula}{a \code{\link{formula}} object for multivariate responses in the form of\cr
\code{cbind(Y1, ..., Yj) ~ X1 + ... + Xp}.
       Responses need to be ordered factors.}

\item{error.structure}{different \code{\link{error.structures}}: general correlation structure (default)\cr
\code{corGeneral(~1)},
general covariance structure \code{covGeneral(~1)}, factor dependent correlation structure \code{covGeneral(~f)},
factor dependent covariance structure \code{covGeneral(~f)}, covariate dependent equicorrelation structure \cr
\code{corEqui(~S)},
AR(1) correlation structure \code{corAR1(~1)} or a covariate dependent \cr
AR(1) correlation structure \code{corAR1(~S)}.
See \code{\link{error.structures}} or 'Details'.}

\item{data}{\code{\link{data.frame}} containing the ordinal observations and the covariates to be used in the model}

\item{link}{\code{"probit"} or \code{"logit"} link function}

\item{coef.constraints}{\code{\link{vector}} or \code{\link{matrix}} of constraints on coefficients. See 'Details'.}

\item{coef.values}{\code{\link{matrix}} setting fixed values on the regression coefficients. See 'Details'.}

\item{threshold.constraints}{\code{\link{vector}} of constraints on thresholds. See 'Details'.}

\item{threshold.values}{(optional) \code{\link{list}} of fixed values for threshold parameters. See 'Details'.}

\item{weights}{(optional) column name of subject-specific weights in \code{data} which need to be
constant across repeated measurements. Negative weights are not allowed.}

\item{se}{logical, if \code{TRUE} standard errors are computed.}

\item{start.values}{vector of (optional) starting values.}

\item{solver}{character string containing the name of the applicable solver of \code{\link{optimx}} (default is \code{"BFGS"}) or wrapper function for user defined solver.}

\item{control}{a list of control arguments. See \code{\link{optimx}}.}
}
\description{
\code{multord2} fits a ordinal regression model for the case where the covariates do not vary\cr over the responses dimensions.
}
\details{
see vignette or \code{\link{multord}}
}
\examples{
library(mvord)

## toy example
data(data_toy_example)

res <- multord2(formula = cbind(Y1,Y2) ~ 0 + X1 + X2,
                data = data_toy_example,
                link = "probit",
                solver = "BFGS",
                se = TRUE,
                error.structure = corGeneral(~1),
                threshold.constraints = c(1,1),
                coef.constraints = c(1,1))
print(res)
summary(res)
thresholds(res)
coefficients(res)
get.error.struct(res)

#load data
data(data_multord2)
head(data_multord2)

#-------------
# corGeneral
#-------------
\donttest{
#approx 1 min
res_cor <- multord2(formula = cbind(rater1, rater2, rater3) ~ 0 + X1 + X2 + X3 + X4 + X5,
#formula ~ 0 ... without intercept
               data = data_multord2, #choose data
               link = "probit", #probit or logit
               error.structure = corGeneral(~1), #different error structures
               coef.constraints = cbind(c(1,2,2),
                                        c(1,1,2),
                                        c(NA,1,2),
                                        c(NA,NA,NA),
                                        c(1,1,2)),#either a vector or a matrix
               coef.values = cbind(c(NA,NA,NA),
                                   c(NA,NA,NA),
                                   c(0,NA,NA),
                                   c(1,1,1),
                                   c(NA,NA,NA)),
                                   #matrix (possible if coef.constraints is a matrix)
               threshold.constraints = c(1,1,2),
               solver = "BFGS")
print(res_cor)
summary(res_cor)
thresholds(res_cor)
coefficients(res_cor)
get.error.struct(res_cor)
}

}
