% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mvtb_plots.R
\name{mvtb.heat}
\alias{mvtb.heat}
\title{Simple (clustered) heatmap of tables from mvtb (relative influence, covariance explained)}
\usage{
mvtb.heat(x, clust.method = "ward.D", dist.method = "manhattan",
  numformat = NULL, col = NULL, cexRow = NULL, cexCol = NULL, ...)
}
\arguments{
\item{x}{Any table. For example: the covariance explained (\code{res$covex}), or relative influence \code{mvtb.ri(res)}}

\item{clust.method}{clustering method for rows and columns. See ?hclust. If NULL, unclustered.}

\item{dist.method}{method for computing the distance between columns See ?dist for alternatives.}

\item{numformat}{function to format the covex values into strings. Defaults to removing leading 0 and rounding to 2 decimal places.}

\item{col}{A list of colors mapping onto covex explained values. A white to black gradient is default.}

\item{cexRow,}{See \code{cex.axis} from par. The magnification used for the row axis labels. A useful default is provided.}

\item{cexCol,}{See \code{cex.axis} from par. The magnification used for the col axis labels. The default is set equal to the row axis labels.}

\item{...}{extra arguments are passed to image, then to plot. See ?image, ?par}
}
\value{
heatmap of x, usually a covariance explained matrix or a matrix of (relative) influences.
}
\description{
Simple (clustered) heatmap of tables from mvtb (relative influence, covariance explained)
}
\details{
You will probably want to modify the default colors.
}
\seealso{
\code{plot.mvtb}, \code{mvtb.perspec}
}

