% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_var_proportions_params.R
\name{validate_var_proportions_params}
\alias{validate_var_proportions_params}
\title{Internal function to validate parameters passed to \code{run_var_proportions}}
\usage{
validate_var_proportions_params(
  mx_data,
  table,
  metadata_cols,
  formula_override,
  save_models
)
}
\arguments{
\item{mx_data}{\code{mx_dataset} object used to compute UMAP dimensions}

\item{table}{dataset in \code{mx_data} used to compute metrics. Options include: c("raw","normalized","both"), e.g. a y-axis parameter.}

\item{metadata_cols}{other identifiers of the input \code{data} to use in the modeling process (default=NULL). This must be a vector of column name(s) in the \code{mx_dataset} object}

\item{formula_override}{String with user-defined formula to use for variance proportions modeling analysis (default=NULL). This will be the RHS of a formula with \verb{marker~} as the LHS.}

\item{save_models}{Boolean flag to save \code{lme4::lmer()} models in a list to the \code{mx_dataset} object}
}
\value{
\code{mx_datast} object
}
\description{
Internal function to validate parameters passed to \code{run_var_proportions}
}
