## ----, echo = FALSE, message = FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(myTAI)
options(width = 750)
knitr::opts_chunk$set(
  comment = "#>",
  error = FALSE,
  tidy = FALSE)

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # install orthologr from GitHub
#  # install.packages("devtools")
#  
#  # install the current version of orthologr on your system
#  library(devtools)
#  install_github("HajkD/orthologr", build_vignettes = TRUE, dependencies = TRUE)
#  
#  # On Windows, this won't work - see ?build_github_devtools
#  install_github("HajkD/orthologr", build_vignettes = TRUE, dependencies = TRUE)
#  
#  # When working with Windows, first you need to install the
#  # R package: rtools -> install.packages("rtools")
#  
#  # Afterwards you can install devtools -> install.packages("devtools")
#  # and then you can run:
#  
#  devtools::install_github("HajkD/orthologr", build_vignettes = TRUE, dependencies = TRUE)
#  
#  # and then call it from the library
#  library("orthologr", lib.loc = "C:/Program Files/R/R-3.1.1/library")
#  

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # install.packages("devtools")
#  
#  # install the current version of biomartr on your system
#  library(devtools)
#  install_github("HajkD/biomartr", build_vignettes = TRUE, dependencies = TRUE)
#  
#  # On Windows, this won't work - see ?build_github_devtools
#  install_github("HajkD/biomartr", build_vignettes = TRUE, dependencies = TRUE)
#  
#  # When working with Windows, first you need to install the
#  # R package: rtools -> install.packages("rtools")
#  
#  # Afterwards you can install devtools -> install.packages("devtools")
#  # and then you can run:
#  
#  devtools::install_github("HajkD/biomartr", build_vignettes = TRUE, dependencies = TRUE)
#  
#  # and then call it from the library
#  library("biomartr", lib.loc = "C:/Program Files/R/R-3.1.1/library")

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # download the proteome of Arabidopsis thaliana from refseq
#  # and store the corresponding proteome file in '_ncbi_downloads/proteomes'
#  Ath_Proteome <- getProteome( db           = "refseq",
#                               kingdom      = "plant",
#                               organism     = "Arabidopsis thaliana",
#                               clean_folder = FALSE )
#  

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  library(orthologr)
#  
#  # compute the divergence map of A. thaliana
#  Athaliana_DM <- divergence_stratigraphy(
#                           query_file      = "path/to/Arabidopsis_thaliana.TAIR10.23.cds.all.fa",
#                           subject_file    = "path/to/Arabidopsis_lyrata.v.1.0.23.cds.all.fa",
#                           eval            = "1E-5",
#                           ortho_detection = "RBH",
#                           comp_cores      = 1,
#                           quiet           = TRUE,
#                           clean_folders   = TRUE )
#  

## ----,eval=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # load the PhyloExpressionSetExample data set
#  data(PhyloExpressionSetExample)
#  
#  # get the ExpressionMatrix covering A. thaliana embryogenesis.
#  ExprMatrix <- PhyloExpressionSetExample[ , 2:9]
#  
#  # match the divergence map with the gene expression set of A. thaliana
#  # to obtain an PhyloExpressionSet object
#  Ath_PhyloExpressionSet <- MatchMap( Map              = Athaliana_DM,
#                                      ExpressionMatrix = ExprMatrix )
#  

## ----, eval=FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # load the PhyloExpressionSetExample data set
#  data(PhyloExpressionSetExample)
#  
#  # look at PhyloExpressionSetExample
#  head(PhyloExpressionSetExample)
#  

