% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_signature.R
\name{plot_signature}
\alias{plot_signature}
\title{Plot Transcriptomic Signature}
\usage{
plot_signature(
  phyex_set,
  show_reps = TRUE,
  show_p_val = TRUE,
  conservation_test = stat_flatline_test,
  colour = NULL,
  ...
)
}
\arguments{
\item{phyex_set}{A PhyloExpressionSet object (BulkPhyloExpressionSet or ScPhyloExpressionSet)}

\item{show_reps}{Logical, whether to show individual replicates}

\item{show_p_val}{Logical, whether to show conservation test p-value}

\item{conservation_test}{Function, conservation test to use for p-value calculation}

\item{colour}{Character, custom color for the plot elements}

\item{...}{Additional arguments passed to specific methods}
}
\value{
A ggplot2 object showing the transcriptomic signature
}
\description{
Create a plot of the transcriptomic index signature across developmental stages
or cell types, with options for showing individual samples/cells and statistical testing.
}
\details{
This function creates visualizations appropriate for the data type:

**Bulk data (BulkPhyloExpressionSet):**
- Line plots showing TXI trends across developmental stages
- Optional individual biological replicates as jittered points
- Optional conservation test p-values

**Single-cell data (ScPhyloExpressionSet):**
- Sina plots showing TXI distributions across cell types or other identities
- Mean TXI values overlaid as line
- Optional individual cells using geom_sina for better visualization
- Flexible identity selection from metadata via additional parameters:
  - `primary_identity`: Character, name of metadata column for x-axis (default: current selected identities)
  - `secondary_identity`: Character, name of metadata column for coloring/faceting
  - `facet_by_secondary`: Logical, whether to facet by secondary identity (default: FALSE uses colouring)
}
\examples{
# Basic signature plot for bulk data
p <- plot_signature(example_phyex_set)

}
