% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-item-interpreting.R
\name{naaccr_datetime}
\alias{naaccr_datetime}
\title{Parse NAACCR-formatted datetimes}
\usage{
naaccr_datetime(datetime)
}
\arguments{
\item{datetime}{Character vector of datetimes in NAACCR format
(\code{"YYYYMMDDHHMMSS"}).}
}
\value{
A \code{POSIXct} vector. Any incomplete or invalid datetimes are
  converted to \code{NA}. The original strings can be retrieved with the
  \code{\link{naaccr_encode}} function.
}
\description{
Parse NAACCR-formatted datetimes
}
\examples{
  input <- c("20151031100856", "20140822    ", "99999999")
  d <- naaccr_datetime(input)
  d
  naaccr_encode(d, "pathDateSpecCollect1")
}
