% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{BrightnessPlotFolder}
\alias{BrightnessPlotFolder}
\title{Make brightness plots (images) for an entire folder.}
\usage{
BrightnessPlotFolder(folder.path = ".", patt = ".*[Bb]rightness.*\\\\.csv$",
  verbose = TRUE, ...)
}
\arguments{
\item{folder.path}{The path (relative or absolute) to the folder you wish to
process.}

\item{patt}{The pattern (in regular expression) of the csv files in the
folder that are brightness images. The default matches any .csv files which
contains 'Brightness' or 'brightness' in its name.}

\item{verbose}{Get a real time report on progress?}

\item{...}{Parameters to pass to \code{\link[=MatrixRasterPlot]{MatrixRasterPlot()}} (these
\emph{must} be named arguments).}
}
\value{
This is a \code{ggplot2} object and can be manipulated thus.
}
\description{
This requires that the folder already have the brightnesses saved as csv
files. Output images are saved as pdf.
}
\examples{
setwd(tempdir())
img <- ReadImageData(system.file('extdata', '50.tif', package = 'nandb'))
WriteIntImage(img, '50.tif')
WriteIntImage(img, '50again.tif')
BrightnessTxtFolder(tau = NA, mst = "Huang", mcc = 2)
BrightnessPlotFolder()
list.files()
file.remove(list.files())  # cleanup

}
