% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_below.R
\name{impute_below_if}
\alias{impute_below_if}
\title{Scoped variants of \code{impute_below}}
\usage{
impute_below_if(.tbl, .predicate, prop_below = 0.1, jitter = 0.05, ...)
}
\arguments{
\item{.tbl}{data.frame}

\item{.predicate}{A predicate function (such as is.numeric)}

\item{prop_below}{the degree to shift the values. default is}

\item{jitter}{the amount of jitter to add. default is 0.05}

\item{...}{extra arguments}
}
\value{
an dataset with values imputed
}
\description{
\code{impute_below} operates on all variables. To only impute variables
that satisfy a specific condition, use the scoped variants,
\code{impute_below_at}, and \code{impute_below_if}.
}
\examples{

airquality \%>\%
  impute_below_if(.predicate = is.numeric)

}
