% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{ctx_recv_vec}
\alias{ctx_recv_vec}
\title{Receive Vector over Context (Async)}
\usage{
ctx_recv_vec(
  context,
  mode = c("character", "complex", "double", "integer", "logical", "numeric", "raw"),
  n = 1L,
  timeout,
  keep.raw = TRUE
)
}
\arguments{
\item{context}{a Context.}

\item{mode}{[default 'character'] mode of vector to be read - one of
'character', 'complex', 'double', 'integer', 'logical', 'numeric', 'raw'.}

\item{n}{[default 1L] number of messages to receive asynchronously.}

\item{timeout}{in ms. If unspecified, a socket-specific default timeout will
be used.}

\item{keep.raw}{[default TRUE] TRUE to keep the received raw vector (useful
for verification e.g. via hashing). If FALSE, will return the
unserialised object only.}
}
\value{
Named list of 2 elements: 'raw' containing a list of received raw
    vectors and 'data' containing a list of vectors decoded to the type 'mode',
    or else a list of vectors decoded to type 'mode' if keep.raw is set to
    FALSE.

    Note: a list of lists is always returned even when n = 1. To access the
    first raw element, for example, use \code{$raw[[1]]} and the first data
    element use \code{$data[[1]]}.
}
\description{
Receive vector data asynchronously over a Context (with ability to set a
    timeout). The counterpart to \code{\link{ctx_send_vec}}, data will be
    re-created from the raw vector according to the specified mode. Can be
    used when interfacing with external programs.
}
\details{
Async recv will block while awaiting all 'n' messages to arrive. Set
    a timeout to ensure that the function returns under all conditions.
}
\examples{
req <- socket("req", listen = "inproc://nanonext")
rep <- socket("rep", dial = "inproc://nanonext")

ctxq <- context(req)
ctxp <- context(rep)
ctx_send_vec(ctxq, c(1.1, 2.2), c(3.3, 4.4), timeout = 100)
ctx_recv_vec(ctxp, "double", 2L, timeout = 100)

close(req)
close(rep)

}
