% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ncurl}
\alias{ncurl}
\title{ncurl}
\usage{
ncurl(http)
}
\arguments{
\item{http}{the URL/address of the resource to retrieve.}
}
\value{
Named list of 2 elements:
    \itemize{
    \item{\code{$raw}} {- a raw vector of the received resource (may be saved
    to a file using \code{\link{writeBin}} to re-create the original)}
    \item{\code{$data}} {- the raw vector converted to a character string (if
    the served content was a recognised text format), allowing further parsing
    within R as html, json, xml etc., or NULL otherwise (if the content was a
    binary file etc.)}
    }
}
\description{
nano cURL - a minimalistic http(s) client.
}
\section{Redirects}{


    In interactive sessions, will prompt upon receiving a redirect location
    whether to follow or not (default: yes). In non-interactive sessions,
    redirects are never followed.
}

\section{TLS Support}{


    Connecting to secure https sites is supported if your version of the NNG
    library was built with TLS support (using Mbed TLS) and the environment
    variable 'NANONEXT_TLS' was set when installing the package e.g. by
    \code{Sys.setenv(NANONEXT_TLS=1)}. Note: not applicable for Windows systems.
}

\examples{
ncurl("http://httpbin.org/headers")

}
