% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{nng_timer}
\alias{nng_timer}
\title{Timer Utility}
\usage{
nng_timer(time)
}
\arguments{
\item{time}{time in ms. Non-integer values are translated to integer using
\code{as.integer()}.}
}
\value{
An external pointer to the thread created by this function.
}
\description{
Set a timer (stopwatch). Will print a message to the console (stderr) upon
    completion.
}
\details{
The return value of this function should not normally be assigned as
    this preserves the thread instead of it being automatically reaped during
    garbage collection.

    As reaping the thread waits until the timer has completed, a possible
    side effect is blocking garbage collection until this has happened
    (not guaranteed, as garbage collection may happen on other objects first).
    If this is undesirable, assign the external pointer to an object and then
    remove it after completion.
}
