% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{send_ctx}
\alias{send_ctx}
\title{Send over Context}
\usage{
send_ctx(context, data, mode = c("serial", "raw"), timeout, echo = TRUE)
}
\arguments{
\item{context}{a Context.}

\item{data}{an object (if mode = 'raw', a vector).}

\item{mode}{[default 'serial'] whether data will be sent serialized or as a
raw vector. Use 'serial' for sending and receiving within R to ensure
perfect reproducibility. Use 'raw' for sending vectors of any type (will be
converted to a raw byte vector for sending) - essential when interfacing
with external applications.}

\item{timeout}{in ms. If unspecified, a socket-specific default timeout will
be used.}

\item{echo}{[default TRUE] logical flag whether to return the raw vector of
sent data. Set to FALSE for performance-critical applications where zero
will be returned (invisibly) instead.}
}
\value{
Raw vector of sent data, or (invisibly) an integer exit code (zero on
    success) if 'echo' is set to FALSE.
}
\description{
Send data over a Context.
}
\details{
Will block if the send is in progress and has not yet completed -
    certain protocol / transport combinations may limit the number of messages
    that can be queued if they have yet to be received. Set a timeout to
    ensure the function returns under all scenarios.
}
\examples{
req <- socket("req", listen = "inproc://nanonext")
rep <- socket("rep", dial = "inproc://nanonext")

ctx <- context(req)
send_ctx(ctx, data.frame(a = 1, b = 2), timeout = 100)

msg <- recv_aio(rep, timeout = 100)
send_ctx(ctx, c(1.1, 2.2, 3.3), mode = "raw", timeout = 100)

close(req)
close(rep)

}
