% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncurl.R
\name{ncurl}
\alias{ncurl}
\title{ncurl}
\usage{
ncurl(
  url,
  async = FALSE,
  convert = TRUE,
  follow = FALSE,
  method = NULL,
  headers = NULL,
  data = NULL,
  response = NULL,
  pem = NULL
)
}
\arguments{
\item{url}{the URL address.}

\item{async}{[default FALSE] logical value whether to perform an async request,
in which case an 'ncurlAio' is returned instead of a list.}

\item{convert}{[default TRUE] logical value whether to attempt conversion of
the received raw bytes to a character vector. Supplying a non-logical
value will error.}

\item{follow}{[default FALSE] logical value whether to automatically follow
redirects (not applicable for async requests). If FALSE (or async), the
redirect address is returned as response header 'Location'. Supplying
a non-logical value will error.}

\item{method}{(optional) the HTTP method (defaults to 'GET' if not specified).}

\item{headers}{(optional) a named list or character vector specifying the
HTTP request headers e.g. \code{list(`Content-Type` = "text/plain")} or
\code{c(Authorization = "Bearer APIKEY")}. Supplying a non-named list or
vector will error.}

\item{data}{(optional) the request data to be submitted.}

\item{response}{(optional) a character vector or list specifying the response
headers to return e.g. \code{c("date", "server")} or \code{list("Date", "Server")}.
These are case-insensitive and will return NULL if not present.}

\item{pem}{(optional) applicable to secure HTTPS sites only. The path to a
file containing X.509 certificate(s) in PEM format, comprising the
certificate authority certificate chain (and revocation list if present).
If missing or NULL, certificates are not validated.}
}
\value{
Named list of 4 elements:
    \itemize{
    \item{\code{$status}} {- integer HTTP repsonse status code (200 - OK).
    Use \code{\link{status_code}} for a translation of the meaning.}
    \item{\code{$headers}} {- named list of response headers supplied in
    'response' or NULL if unspecified. If the status code is within the 300
    range, i.e. a redirect, the response header 'Location' is automatically
    appended to return the redirect address.}
    \item{\code{$raw}} {- raw vector of the received resource (use
    \code{\link{writeBin}} to save to a file).}
    \item{\code{$data}} {- converted character string (if \code{'convert' = TRUE}
    and content is a recognised text format), or NULL otherwise. Other tools
    can be used to further parse this as html, json, xml etc. if required.}
    }

    Or else, if \code{async = TRUE}, an 'ncurlAio' (object of class 'ncurlAio'
    and 'recvAio') (invisibly).
}
\description{
nano cURL - a minimalist http(s) client.
}
\examples{
ncurl("https://httpbin.org/get", response = c("date", "server"))
ncurl("http://httpbin.org/put",,,,"PUT", list(Authorization = "Bearer APIKEY"), "hello world")
ncurl("http://httpbin.org/post",,,,"POST", c(`Content-Type` = "application/json"),'{"k":"v"}')

}
