% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{setopt}
\alias{setopt}
\title{Set Option on Socket, Context, Stream, Listener or Dialer}
\usage{
setopt(object, opt, value)
}
\arguments{
\item{object}{a Socket, Context, Stream, Listener or Dialer.}

\item{opt}{name of option, e.g. 'reconnect-time-min', as a character string.
See \link{opts}.}

\item{value}{value of option. Supply character type for 'string' options,
integer or double for 'int', 'duration', 'size' and 'uint64', and logical
for 'bool'.}
}
\value{
Invisibly, an integer exit code (zero on success).
}
\description{
Set \link{opts} on a Socket, Context, Stream, Listener or Dialer.
}
\details{
Note: once a dialer or listener has started, it is not generally
    possible to change its configuration. Hence create the dialer or listener
    with 'autostart = FALSE' if configuration needs to be set.

    To set options on a Listener or Dialer attached to a Socket or nano object,
    pass in the objects directly via for example \code{$listener[[1]]} for
    the first Listener.
}
\examples{
s <- socket("pair")
setopt(s, "recv-timeout", 2000)
close(s)

s <- socket("req")
ctx <- context(s)
setopt(ctx, "send-timeout", 2000)
close(ctx)
close(s)

s <- socket("pair", dial = "inproc://nanonext", autostart = FALSE)
setopt(s$dialer[[1]], "reconnect-time-min", 2000)
start(s$dialer[[1]])
close(s)

s <- socket("pair", listen = "inproc://nanonext", autostart = FALSE)
setopt(s$listener[[1]], "recv-size-max", 1024)
start(s$listener[[1]])
close(s)

}
