% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{unsubscribe}
\alias{unsubscribe}
\title{Unsubscribe Topic}
\usage{
unsubscribe(con, topic = NULL)
}
\arguments{
\item{con}{a Socket or Context using the 'sub' protocol.}

\item{topic}{[default NULL] an atomic type or NULL. The default NULL
unsubscribes from all topics (if all topics were previously subscribed).}
}
\value{
Invisibly, an integer exit code (zero on success).
}
\description{
For a socket or context using the sub protocol in a publisher/subscriber
    pattern. Remove a topic from the subscription list.
}
\details{
Note that if the topic was not previously subscribed to then an
    'entry not found' error will result.

    To use pub/sub the publisher must:
    \itemize{
    \item{specify \code{mode = 'raw'} when sending.}
    \item{ensure the sent vector starts with the topic.}
    }
    The subscriber should then receive specifying the correct mode.
}
\examples{
pub <- socket("pub", listen = "inproc://nanonext")
sub <- socket("sub", dial = "inproc://nanonext")

subscribe(sub, "examples")
send(pub, c("examples", "this is an example"), mode = "raw")
recv(sub, "character")
unsubscribe(sub, "examples")
send(pub, c("examples", "this example will not be received"), mode = "raw")
recv(sub, "character")

subscribe(sub, 2)
send(pub, c(2, 10, 10, 20), mode = "raw")
recv(sub, "double", keep.raw = FALSE)
unsubscribe(sub, 2)
send(pub, c(2, 10, 10, 20), mode = "raw")
recv(sub, "double", keep.raw = FALSE)

close(pub)
close(sub)

}
