% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{weakref<-}
\alias{weakref<-}
\title{Make Weak Reference}
\usage{
weakref(key) <- value
}
\arguments{
\item{key}{a reference object i.e. an environment or external pointer.}

\item{value}{an object.}
}
\value{
'key' (with 'value' registered as a weak reference).
}
\description{
Exposes R's C API function \code{R_MakeWeakRef}, for registering a 'value' to
    a 'key' as a weak reference. The object 'value' is kept alive as long as
    'key' remains reachable.
}
\details{
If 'value' is an external pointer, an appropriate finaliser for
    'value' should be registered separately, as this function does not
    register any finalisers to be run when 'key' becomes unreachable.
}
