% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{lock}
\alias{lock}
\alias{unlock}
\title{Lock / Unlock a Socket}
\usage{
lock(socket, cv = NULL)

unlock(socket)
}
\arguments{
\item{socket}{a Socket.}

\item{cv}{(optional) a 'conditionVariable'. If supplied, the socket is locked
only while the value of the condition variable is non-zero.}
}
\value{
Invisibly, zero on success (will otherwise error).
}
\description{
Prevents further pipe connections from being established at a Socket.
}
\examples{
s <- socket("bus", listen = "inproc://nanolock")
s1 <- socket("bus", dial = "inproc://nanolock")
lock(s)
s2 <- socket("bus", dial = "inproc://nanolock")

send(s, "test")
recv(s1)
recv(s2)

unlock(s)
s3 <- socket("bus", dial = "inproc://nanolock")
send(s, "test")
recv(s1)
recv(s3)

close(s)
close(s1)
close(s2)
close(s3)

}
