% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream.R
\name{stream}
\alias{stream}
\title{Open Stream}
\usage{
stream(dial = NULL, listen = NULL, textframes = FALSE, tls = NULL)
}
\arguments{
\item{dial}{a URL to dial, specifying the transport and address as a character
string e.g. 'ipc:///tmp/anyvalue' or 'tcp://127.0.0.1:5555'
(not all transports are supported).}

\item{listen}{a URL to listen at, specifying the transport and address as a
character string e.g. 'ipc:///tmp/anyvalue' or 'tcp://127.0.0.1:5555'
(not all transports are supported).}

\item{textframes}{[default FALSE] applicable to the websocket transport only,
enables sending and receiving of TEXT frames (ignored otherwise).}

\item{tls}{(optional) applicable to secure websockets only, a client or
server TLS configuration object created by \code{\link{tls_config}}. If
missing or NULL, certificates are not validated.}
}
\value{
A Stream (object of class \sQuote{nanoStream} and \sQuote{nano}).
}
\description{
Open a Stream by either dialing (establishing an outgoing connection) or
    listening (accepting an incoming connection) at an address. This is a
    low-level interface intended for communicating with non-NNG
    endpoints.
}
\details{
A Stream is used for raw byte stream connections. Byte streams are
    reliable in that data will not be delivered out of order, or with portions
    missing.

    Can be used to dial a (secure) websocket address starting 'ws://' or
    'wss://'. It is often the case that 'textframes' needs to be set to TRUE.

    Specify only one of 'dial' or 'listen'. If both are specified, 'listen'
    will be ignored.
}
\examples{
# will succeed only if there is an open connection at the address:
s <- tryCatch(stream(dial = "tcp://127.0.0.1:5555"), error = identity)
s

}
