% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nanoparquet.R
\name{write_parquet}
\alias{write_parquet}
\title{Write a data frame to a Parquet file}
\usage{
write_parquet(
  x,
  file,
  compression = c("snappy", "uncompressed"),
  metadata = NULL
)
}
\arguments{
\item{x}{Data frame to write.}

\item{file}{Path to the output file.}

\item{compression}{Compression algorithm to use. Currently only
\code{"snappy"} (the default) and \code{"uncompressed"} are supported.}

\item{metadata}{Additional key-value metadata to add to the file.
This must be a named character vector, or a data frame with columns
character columns called \code{key} and \code{value}.}
}
\value{
\code{NULL}
}
\description{
Writes the contents of an R data frame into a Parquet file.
}
\details{
\code{write_parquet()} converts string columns to UTF-8 encoding by calling
\code{\link[base:Encoding]{base::enc2utf8()}}. It does the same for factor levels.
}
\examples{
\dontshow{if (!nanoparquet:::is_rcmd_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# add row names as a column, because `write_parquet()` ignores them.
mtcars2 <- cbind(name = rownames(mtcars), mtcars)
write_parquet(mtcars2, "mtcars.parquet")
\dontshow{if (!nanoparquet:::is_rcmd_check()) unlink("mtcars.parquet")}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=parquet_metadata]{parquet_metadata()}}, \code{\link[=read_parquet]{read_parquet()}}.
}
