// automatically generated by the FlatBuffers compiler, do not modify


#ifndef FLATBUFFERS_GENERATED_MESSAGE_ORG_APACHE_ARROW_FLATBUF_H_
#define FLATBUFFERS_GENERATED_MESSAGE_ORG_APACHE_ARROW_FLATBUF_H_

#include "flatbuffers/flatbuffers.h"

// Ensure the included flatbuffers.h is the same version as when this file was
// generated, otherwise it may not be compatible.
static_assert(FLATBUFFERS_VERSION_MAJOR == 24 &&
              FLATBUFFERS_VERSION_MINOR == 3 &&
              FLATBUFFERS_VERSION_REVISION == 25,
             "Non-compatible flatbuffers version included");

#include "Schema_generated.h"
#include "SparseTensor_generated.h"
#include "Tensor_generated.h"

namespace org {
namespace apache {
namespace arrow {
namespace flatbuf {

struct FieldNode;

struct BodyCompression;
struct BodyCompressionBuilder;
struct BodyCompressionT;

struct RecordBatch;
struct RecordBatchBuilder;
struct RecordBatchT;

struct DictionaryBatch;
struct DictionaryBatchBuilder;
struct DictionaryBatchT;

struct Message;
struct MessageBuilder;
struct MessageT;

enum CompressionType : int8_t {
  CompressionType_LZ4_FRAME = 0,
  CompressionType_ZSTD = 1,
  CompressionType_MIN = CompressionType_LZ4_FRAME,
  CompressionType_MAX = CompressionType_ZSTD
};

inline const CompressionType (&EnumValuesCompressionType())[2] {
  static const CompressionType values[] = {
    CompressionType_LZ4_FRAME,
    CompressionType_ZSTD
  };
  return values;
}

inline const char * const *EnumNamesCompressionType() {
  static const char * const names[3] = {
    "LZ4_FRAME",
    "ZSTD",
    nullptr
  };
  return names;
}

inline const char *EnumNameCompressionType(CompressionType e) {
  if (::flatbuffers::IsOutRange(e, CompressionType_LZ4_FRAME, CompressionType_ZSTD)) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesCompressionType()[index];
}

/// Provided for forward compatibility in case we need to support different
/// strategies for compressing the IPC message body (like whole-body
/// compression rather than buffer-level) in the future
enum BodyCompressionMethod : int8_t {
  /// Each constituent buffer is first compressed with the indicated
  /// compressor, and then written with the uncompressed length in the first 8
  /// bytes as a 64-bit little-endian signed integer followed by the compressed
  /// buffer bytes (and then padding as required by the protocol). The
  /// uncompressed length may be set to -1 to indicate that the data that
  /// follows is not compressed, which can be useful for cases where
  /// compression does not yield appreciable savings.
  BodyCompressionMethod_BUFFER = 0,
  BodyCompressionMethod_MIN = BodyCompressionMethod_BUFFER,
  BodyCompressionMethod_MAX = BodyCompressionMethod_BUFFER
};

inline const BodyCompressionMethod (&EnumValuesBodyCompressionMethod())[1] {
  static const BodyCompressionMethod values[] = {
    BodyCompressionMethod_BUFFER
  };
  return values;
}

inline const char * const *EnumNamesBodyCompressionMethod() {
  static const char * const names[2] = {
    "BUFFER",
    nullptr
  };
  return names;
}

inline const char *EnumNameBodyCompressionMethod(BodyCompressionMethod e) {
  if (::flatbuffers::IsOutRange(e, BodyCompressionMethod_BUFFER, BodyCompressionMethod_BUFFER)) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesBodyCompressionMethod()[index];
}

/// ----------------------------------------------------------------------
/// The root Message type
/// This union enables us to easily send different message types without
/// redundant storage, and in the future we can easily add new message types.
///
/// Arrow implementations do not need to implement all of the message types,
/// which may include experimental metadata types. For maximum compatibility,
/// it is best to send data using RecordBatch
enum MessageHeader : uint8_t {
  MessageHeader_NONE = 0,
  MessageHeader_Schema = 1,
  MessageHeader_DictionaryBatch = 2,
  MessageHeader_RecordBatch = 3,
  MessageHeader_Tensor = 4,
  MessageHeader_SparseTensor = 5,
  MessageHeader_MIN = MessageHeader_NONE,
  MessageHeader_MAX = MessageHeader_SparseTensor
};

inline const MessageHeader (&EnumValuesMessageHeader())[6] {
  static const MessageHeader values[] = {
    MessageHeader_NONE,
    MessageHeader_Schema,
    MessageHeader_DictionaryBatch,
    MessageHeader_RecordBatch,
    MessageHeader_Tensor,
    MessageHeader_SparseTensor
  };
  return values;
}

inline const char * const *EnumNamesMessageHeader() {
  static const char * const names[7] = {
    "NONE",
    "Schema",
    "DictionaryBatch",
    "RecordBatch",
    "Tensor",
    "SparseTensor",
    nullptr
  };
  return names;
}

inline const char *EnumNameMessageHeader(MessageHeader e) {
  if (::flatbuffers::IsOutRange(e, MessageHeader_NONE, MessageHeader_SparseTensor)) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesMessageHeader()[index];
}

template<typename T> struct MessageHeaderTraits {
  static const MessageHeader enum_value = MessageHeader_NONE;
};

template<> struct MessageHeaderTraits<org::apache::arrow::flatbuf::Schema> {
  static const MessageHeader enum_value = MessageHeader_Schema;
};

template<> struct MessageHeaderTraits<org::apache::arrow::flatbuf::DictionaryBatch> {
  static const MessageHeader enum_value = MessageHeader_DictionaryBatch;
};

template<> struct MessageHeaderTraits<org::apache::arrow::flatbuf::RecordBatch> {
  static const MessageHeader enum_value = MessageHeader_RecordBatch;
};

template<> struct MessageHeaderTraits<org::apache::arrow::flatbuf::Tensor> {
  static const MessageHeader enum_value = MessageHeader_Tensor;
};

template<> struct MessageHeaderTraits<org::apache::arrow::flatbuf::SparseTensor> {
  static const MessageHeader enum_value = MessageHeader_SparseTensor;
};

template<typename T> struct MessageHeaderUnionTraits {
  static const MessageHeader enum_value = MessageHeader_NONE;
};

template<> struct MessageHeaderUnionTraits<org::apache::arrow::flatbuf::SchemaT> {
  static const MessageHeader enum_value = MessageHeader_Schema;
};

template<> struct MessageHeaderUnionTraits<org::apache::arrow::flatbuf::DictionaryBatchT> {
  static const MessageHeader enum_value = MessageHeader_DictionaryBatch;
};

template<> struct MessageHeaderUnionTraits<org::apache::arrow::flatbuf::RecordBatchT> {
  static const MessageHeader enum_value = MessageHeader_RecordBatch;
};

template<> struct MessageHeaderUnionTraits<org::apache::arrow::flatbuf::TensorT> {
  static const MessageHeader enum_value = MessageHeader_Tensor;
};

template<> struct MessageHeaderUnionTraits<org::apache::arrow::flatbuf::SparseTensorT> {
  static const MessageHeader enum_value = MessageHeader_SparseTensor;
};

struct MessageHeaderUnion {
  MessageHeader type;
  void *value;

  MessageHeaderUnion() : type(MessageHeader_NONE), value(nullptr) {}
  MessageHeaderUnion(MessageHeaderUnion&& u) FLATBUFFERS_NOEXCEPT :
    type(MessageHeader_NONE), value(nullptr)
    { std::swap(type, u.type); std::swap(value, u.value); }
  MessageHeaderUnion(const MessageHeaderUnion &);
  MessageHeaderUnion &operator=(const MessageHeaderUnion &u)
    { MessageHeaderUnion t(u); std::swap(type, t.type); std::swap(value, t.value); return *this; }
  MessageHeaderUnion &operator=(MessageHeaderUnion &&u) FLATBUFFERS_NOEXCEPT
    { std::swap(type, u.type); std::swap(value, u.value); return *this; }
  ~MessageHeaderUnion() { Reset(); }

  void Reset();

  template <typename T>
  void Set(T&& val) {
    typedef typename std::remove_reference<T>::type RT;
    Reset();
    type = MessageHeaderUnionTraits<RT>::enum_value;
    if (type != MessageHeader_NONE) {
      value = new RT(std::forward<T>(val));
    }
  }

  static void *UnPack(const void *obj, MessageHeader type, const ::flatbuffers::resolver_function_t *resolver);
  ::flatbuffers::Offset<void> Pack(::flatbuffers::FlatBufferBuilder &_fbb, const ::flatbuffers::rehasher_function_t *_rehasher = nullptr) const;

  org::apache::arrow::flatbuf::SchemaT *AsSchema() {
    return type == MessageHeader_Schema ?
      reinterpret_cast<org::apache::arrow::flatbuf::SchemaT *>(value) : nullptr;
  }
  const org::apache::arrow::flatbuf::SchemaT *AsSchema() const {
    return type == MessageHeader_Schema ?
      reinterpret_cast<const org::apache::arrow::flatbuf::SchemaT *>(value) : nullptr;
  }
  org::apache::arrow::flatbuf::DictionaryBatchT *AsDictionaryBatch() {
    return type == MessageHeader_DictionaryBatch ?
      reinterpret_cast<org::apache::arrow::flatbuf::DictionaryBatchT *>(value) : nullptr;
  }
  const org::apache::arrow::flatbuf::DictionaryBatchT *AsDictionaryBatch() const {
    return type == MessageHeader_DictionaryBatch ?
      reinterpret_cast<const org::apache::arrow::flatbuf::DictionaryBatchT *>(value) : nullptr;
  }
  org::apache::arrow::flatbuf::RecordBatchT *AsRecordBatch() {
    return type == MessageHeader_RecordBatch ?
      reinterpret_cast<org::apache::arrow::flatbuf::RecordBatchT *>(value) : nullptr;
  }
  const org::apache::arrow::flatbuf::RecordBatchT *AsRecordBatch() const {
    return type == MessageHeader_RecordBatch ?
      reinterpret_cast<const org::apache::arrow::flatbuf::RecordBatchT *>(value) : nullptr;
  }
  org::apache::arrow::flatbuf::TensorT *AsTensor() {
    return type == MessageHeader_Tensor ?
      reinterpret_cast<org::apache::arrow::flatbuf::TensorT *>(value) : nullptr;
  }
  const org::apache::arrow::flatbuf::TensorT *AsTensor() const {
    return type == MessageHeader_Tensor ?
      reinterpret_cast<const org::apache::arrow::flatbuf::TensorT *>(value) : nullptr;
  }
  org::apache::arrow::flatbuf::SparseTensorT *AsSparseTensor() {
    return type == MessageHeader_SparseTensor ?
      reinterpret_cast<org::apache::arrow::flatbuf::SparseTensorT *>(value) : nullptr;
  }
  const org::apache::arrow::flatbuf::SparseTensorT *AsSparseTensor() const {
    return type == MessageHeader_SparseTensor ?
      reinterpret_cast<const org::apache::arrow::flatbuf::SparseTensorT *>(value) : nullptr;
  }
};

bool VerifyMessageHeader(::flatbuffers::Verifier &verifier, const void *obj, MessageHeader type);
bool VerifyMessageHeaderVector(::flatbuffers::Verifier &verifier, const ::flatbuffers::Vector<::flatbuffers::Offset<void>> *values, const ::flatbuffers::Vector<uint8_t> *types);

/// ----------------------------------------------------------------------
/// Data structures for describing a table row batch (a collection of
/// equal-length Arrow arrays)
/// Metadata about a field at some level of a nested type tree (but not
/// its children).
///
/// For example, a List<Int16> with values `[[1, 2, 3], null, [4], [5, 6], null]`
/// would have {length: 5, null_count: 2} for its List node, and {length: 6,
/// null_count: 0} for its Int16 node, as separate FieldNode structs
FLATBUFFERS_MANUALLY_ALIGNED_STRUCT(8) FieldNode FLATBUFFERS_FINAL_CLASS {
 private:
  int64_t length_;
  int64_t null_count_;

 public:
  FieldNode()
      : length_(0),
        null_count_(0) {
  }
  FieldNode(int64_t _length, int64_t _null_count)
      : length_(::flatbuffers::EndianScalar(_length)),
        null_count_(::flatbuffers::EndianScalar(_null_count)) {
  }
  /// The number of value slots in the Arrow array at this level of a nested
  /// tree
  int64_t length() const {
    return ::flatbuffers::EndianScalar(length_);
  }
  /// The number of observed nulls. Fields with null_count == 0 may choose not
  /// to write their physical validity bitmap out as a materialized buffer,
  /// instead setting the length of the bitmap buffer to 0.
  int64_t null_count() const {
    return ::flatbuffers::EndianScalar(null_count_);
  }
};
FLATBUFFERS_STRUCT_END(FieldNode, 16);

struct BodyCompressionT : public ::flatbuffers::NativeTable {
  typedef BodyCompression TableType;
  org::apache::arrow::flatbuf::CompressionType codec = org::apache::arrow::flatbuf::CompressionType_LZ4_FRAME;
  org::apache::arrow::flatbuf::BodyCompressionMethod method = org::apache::arrow::flatbuf::BodyCompressionMethod_BUFFER;
};

/// Optional compression for the memory buffers constituting IPC message
/// bodies. Intended for use with RecordBatch but could be used for other
/// message types
struct BodyCompression FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef BodyCompressionT NativeTableType;
  typedef BodyCompressionBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_CODEC = 4,
    VT_METHOD = 6
  };
  /// Compressor library.
  /// For LZ4_FRAME, each compressed buffer must consist of a single frame.
  org::apache::arrow::flatbuf::CompressionType codec() const {
    return static_cast<org::apache::arrow::flatbuf::CompressionType>(GetField<int8_t>(VT_CODEC, 0));
  }
  /// Indicates the way the record batch body was compressed
  org::apache::arrow::flatbuf::BodyCompressionMethod method() const {
    return static_cast<org::apache::arrow::flatbuf::BodyCompressionMethod>(GetField<int8_t>(VT_METHOD, 0));
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int8_t>(verifier, VT_CODEC, 1) &&
           VerifyField<int8_t>(verifier, VT_METHOD, 1) &&
           verifier.EndTable();
  }
  BodyCompressionT *UnPack(const ::flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(BodyCompressionT *_o, const ::flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static ::flatbuffers::Offset<BodyCompression> Pack(::flatbuffers::FlatBufferBuilder &_fbb, const BodyCompressionT* _o, const ::flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct BodyCompressionBuilder {
  typedef BodyCompression Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_codec(org::apache::arrow::flatbuf::CompressionType codec) {
    fbb_.AddElement<int8_t>(BodyCompression::VT_CODEC, static_cast<int8_t>(codec), 0);
  }
  void add_method(org::apache::arrow::flatbuf::BodyCompressionMethod method) {
    fbb_.AddElement<int8_t>(BodyCompression::VT_METHOD, static_cast<int8_t>(method), 0);
  }
  explicit BodyCompressionBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<BodyCompression> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<BodyCompression>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<BodyCompression> CreateBodyCompression(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    org::apache::arrow::flatbuf::CompressionType codec = org::apache::arrow::flatbuf::CompressionType_LZ4_FRAME,
    org::apache::arrow::flatbuf::BodyCompressionMethod method = org::apache::arrow::flatbuf::BodyCompressionMethod_BUFFER) {
  BodyCompressionBuilder builder_(_fbb);
  builder_.add_method(method);
  builder_.add_codec(codec);
  return builder_.Finish();
}

::flatbuffers::Offset<BodyCompression> CreateBodyCompression(::flatbuffers::FlatBufferBuilder &_fbb, const BodyCompressionT *_o, const ::flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct RecordBatchT : public ::flatbuffers::NativeTable {
  typedef RecordBatch TableType;
  int64_t length = 0;
  std::vector<org::apache::arrow::flatbuf::FieldNode> nodes{};
  std::vector<org::apache::arrow::flatbuf::Buffer> buffers{};
  std::unique_ptr<org::apache::arrow::flatbuf::BodyCompressionT> compression{};
  std::vector<int64_t> variadicBufferCounts{};
  RecordBatchT() = default;
  RecordBatchT(const RecordBatchT &o);
  RecordBatchT(RecordBatchT&&) FLATBUFFERS_NOEXCEPT = default;
  RecordBatchT &operator=(RecordBatchT o) FLATBUFFERS_NOEXCEPT;
};

/// A data header describing the shared memory layout of a "record" or "row"
/// batch. Some systems call this a "row batch" internally and others a "record
/// batch".
struct RecordBatch FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef RecordBatchT NativeTableType;
  typedef RecordBatchBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_LENGTH = 4,
    VT_NODES = 6,
    VT_BUFFERS = 8,
    VT_COMPRESSION = 10,
    VT_VARIADICBUFFERCOUNTS = 12
  };
  /// number of records / rows. The arrays in the batch should all have this
  /// length
  int64_t length() const {
    return GetField<int64_t>(VT_LENGTH, 0);
  }
  /// Nodes correspond to the pre-ordered flattened logical schema
  const ::flatbuffers::Vector<const org::apache::arrow::flatbuf::FieldNode *> *nodes() const {
    return GetPointer<const ::flatbuffers::Vector<const org::apache::arrow::flatbuf::FieldNode *> *>(VT_NODES);
  }
  /// Buffers correspond to the pre-ordered flattened buffer tree
  ///
  /// The number of buffers appended to this list depends on the schema. For
  /// example, most primitive arrays will have 2 buffers, 1 for the validity
  /// bitmap and 1 for the values. For struct arrays, there will only be a
  /// single buffer for the validity (nulls) bitmap
  const ::flatbuffers::Vector<const org::apache::arrow::flatbuf::Buffer *> *buffers() const {
    return GetPointer<const ::flatbuffers::Vector<const org::apache::arrow::flatbuf::Buffer *> *>(VT_BUFFERS);
  }
  /// Optional compression of the message body
  const org::apache::arrow::flatbuf::BodyCompression *compression() const {
    return GetPointer<const org::apache::arrow::flatbuf::BodyCompression *>(VT_COMPRESSION);
  }
  /// Some types such as Utf8View are represented using a variable number of buffers.
  /// For each such Field in the pre-ordered flattened logical schema, there will be
  /// an entry in variadicBufferCounts to indicate the number of number of variadic
  /// buffers which belong to that Field in the current RecordBatch.
  ///
  /// For example, the schema
  ///     col1: Struct<alpha: Int32, beta: BinaryView, gamma: Float64>
  ///     col2: Utf8View
  /// contains two Fields with variadic buffers so variadicBufferCounts will have
  /// two entries, the first counting the variadic buffers of `col1.beta` and the
  /// second counting `col2`'s.
  ///
  /// This field may be omitted if and only if the schema contains no Fields with
  /// a variable number of buffers, such as BinaryView and Utf8View.
  const ::flatbuffers::Vector<int64_t> *variadicBufferCounts() const {
    return GetPointer<const ::flatbuffers::Vector<int64_t> *>(VT_VARIADICBUFFERCOUNTS);
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int64_t>(verifier, VT_LENGTH, 8) &&
           VerifyOffset(verifier, VT_NODES) &&
           verifier.VerifyVector(nodes()) &&
           VerifyOffset(verifier, VT_BUFFERS) &&
           verifier.VerifyVector(buffers()) &&
           VerifyOffset(verifier, VT_COMPRESSION) &&
           verifier.VerifyTable(compression()) &&
           VerifyOffset(verifier, VT_VARIADICBUFFERCOUNTS) &&
           verifier.VerifyVector(variadicBufferCounts()) &&
           verifier.EndTable();
  }
  RecordBatchT *UnPack(const ::flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(RecordBatchT *_o, const ::flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static ::flatbuffers::Offset<RecordBatch> Pack(::flatbuffers::FlatBufferBuilder &_fbb, const RecordBatchT* _o, const ::flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct RecordBatchBuilder {
  typedef RecordBatch Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_length(int64_t length) {
    fbb_.AddElement<int64_t>(RecordBatch::VT_LENGTH, length, 0);
  }
  void add_nodes(::flatbuffers::Offset<::flatbuffers::Vector<const org::apache::arrow::flatbuf::FieldNode *>> nodes) {
    fbb_.AddOffset(RecordBatch::VT_NODES, nodes);
  }
  void add_buffers(::flatbuffers::Offset<::flatbuffers::Vector<const org::apache::arrow::flatbuf::Buffer *>> buffers) {
    fbb_.AddOffset(RecordBatch::VT_BUFFERS, buffers);
  }
  void add_compression(::flatbuffers::Offset<org::apache::arrow::flatbuf::BodyCompression> compression) {
    fbb_.AddOffset(RecordBatch::VT_COMPRESSION, compression);
  }
  void add_variadicBufferCounts(::flatbuffers::Offset<::flatbuffers::Vector<int64_t>> variadicBufferCounts) {
    fbb_.AddOffset(RecordBatch::VT_VARIADICBUFFERCOUNTS, variadicBufferCounts);
  }
  explicit RecordBatchBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<RecordBatch> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<RecordBatch>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<RecordBatch> CreateRecordBatch(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    int64_t length = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<const org::apache::arrow::flatbuf::FieldNode *>> nodes = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<const org::apache::arrow::flatbuf::Buffer *>> buffers = 0,
    ::flatbuffers::Offset<org::apache::arrow::flatbuf::BodyCompression> compression = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<int64_t>> variadicBufferCounts = 0) {
  RecordBatchBuilder builder_(_fbb);
  builder_.add_length(length);
  builder_.add_variadicBufferCounts(variadicBufferCounts);
  builder_.add_compression(compression);
  builder_.add_buffers(buffers);
  builder_.add_nodes(nodes);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<RecordBatch> CreateRecordBatchDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    int64_t length = 0,
    const std::vector<org::apache::arrow::flatbuf::FieldNode> *nodes = nullptr,
    const std::vector<org::apache::arrow::flatbuf::Buffer> *buffers = nullptr,
    ::flatbuffers::Offset<org::apache::arrow::flatbuf::BodyCompression> compression = 0,
    const std::vector<int64_t> *variadicBufferCounts = nullptr) {
  auto nodes__ = nodes ? _fbb.CreateVectorOfStructs<org::apache::arrow::flatbuf::FieldNode>(*nodes) : 0;
  auto buffers__ = buffers ? _fbb.CreateVectorOfStructs<org::apache::arrow::flatbuf::Buffer>(*buffers) : 0;
  auto variadicBufferCounts__ = variadicBufferCounts ? _fbb.CreateVector<int64_t>(*variadicBufferCounts) : 0;
  return org::apache::arrow::flatbuf::CreateRecordBatch(
      _fbb,
      length,
      nodes__,
      buffers__,
      compression,
      variadicBufferCounts__);
}

::flatbuffers::Offset<RecordBatch> CreateRecordBatch(::flatbuffers::FlatBufferBuilder &_fbb, const RecordBatchT *_o, const ::flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct DictionaryBatchT : public ::flatbuffers::NativeTable {
  typedef DictionaryBatch TableType;
  int64_t id = 0;
  std::unique_ptr<org::apache::arrow::flatbuf::RecordBatchT> data{};
  bool isDelta = false;
  DictionaryBatchT() = default;
  DictionaryBatchT(const DictionaryBatchT &o);
  DictionaryBatchT(DictionaryBatchT&&) FLATBUFFERS_NOEXCEPT = default;
  DictionaryBatchT &operator=(DictionaryBatchT o) FLATBUFFERS_NOEXCEPT;
};

/// For sending dictionary encoding information. Any Field can be
/// dictionary-encoded, but in this case none of its children may be
/// dictionary-encoded.
/// There is one vector / column per dictionary, but that vector / column
/// may be spread across multiple dictionary batches by using the isDelta
/// flag
struct DictionaryBatch FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef DictionaryBatchT NativeTableType;
  typedef DictionaryBatchBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_ID = 4,
    VT_DATA = 6,
    VT_ISDELTA = 8
  };
  int64_t id() const {
    return GetField<int64_t>(VT_ID, 0);
  }
  const org::apache::arrow::flatbuf::RecordBatch *data() const {
    return GetPointer<const org::apache::arrow::flatbuf::RecordBatch *>(VT_DATA);
  }
  /// If isDelta is true the values in the dictionary are to be appended to a
  /// dictionary with the indicated id. If isDelta is false this dictionary
  /// should replace the existing dictionary.
  bool isDelta() const {
    return GetField<uint8_t>(VT_ISDELTA, 0) != 0;
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int64_t>(verifier, VT_ID, 8) &&
           VerifyOffset(verifier, VT_DATA) &&
           verifier.VerifyTable(data()) &&
           VerifyField<uint8_t>(verifier, VT_ISDELTA, 1) &&
           verifier.EndTable();
  }
  DictionaryBatchT *UnPack(const ::flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(DictionaryBatchT *_o, const ::flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static ::flatbuffers::Offset<DictionaryBatch> Pack(::flatbuffers::FlatBufferBuilder &_fbb, const DictionaryBatchT* _o, const ::flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct DictionaryBatchBuilder {
  typedef DictionaryBatch Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_id(int64_t id) {
    fbb_.AddElement<int64_t>(DictionaryBatch::VT_ID, id, 0);
  }
  void add_data(::flatbuffers::Offset<org::apache::arrow::flatbuf::RecordBatch> data) {
    fbb_.AddOffset(DictionaryBatch::VT_DATA, data);
  }
  void add_isDelta(bool isDelta) {
    fbb_.AddElement<uint8_t>(DictionaryBatch::VT_ISDELTA, static_cast<uint8_t>(isDelta), 0);
  }
  explicit DictionaryBatchBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<DictionaryBatch> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<DictionaryBatch>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<DictionaryBatch> CreateDictionaryBatch(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    int64_t id = 0,
    ::flatbuffers::Offset<org::apache::arrow::flatbuf::RecordBatch> data = 0,
    bool isDelta = false) {
  DictionaryBatchBuilder builder_(_fbb);
  builder_.add_id(id);
  builder_.add_data(data);
  builder_.add_isDelta(isDelta);
  return builder_.Finish();
}

::flatbuffers::Offset<DictionaryBatch> CreateDictionaryBatch(::flatbuffers::FlatBufferBuilder &_fbb, const DictionaryBatchT *_o, const ::flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct MessageT : public ::flatbuffers::NativeTable {
  typedef Message TableType;
  org::apache::arrow::flatbuf::MetadataVersion version = org::apache::arrow::flatbuf::MetadataVersion_V1;
  org::apache::arrow::flatbuf::MessageHeaderUnion header{};
  int64_t bodyLength = 0;
  std::vector<std::unique_ptr<org::apache::arrow::flatbuf::KeyValueT>> custom_metadata{};
  MessageT() = default;
  MessageT(const MessageT &o);
  MessageT(MessageT&&) FLATBUFFERS_NOEXCEPT = default;
  MessageT &operator=(MessageT o) FLATBUFFERS_NOEXCEPT;
};

struct Message FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef MessageT NativeTableType;
  typedef MessageBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_VERSION = 4,
    VT_HEADER_TYPE = 6,
    VT_HEADER = 8,
    VT_BODYLENGTH = 10,
    VT_CUSTOM_METADATA = 12
  };
  org::apache::arrow::flatbuf::MetadataVersion version() const {
    return static_cast<org::apache::arrow::flatbuf::MetadataVersion>(GetField<int16_t>(VT_VERSION, 0));
  }
  org::apache::arrow::flatbuf::MessageHeader header_type() const {
    return static_cast<org::apache::arrow::flatbuf::MessageHeader>(GetField<uint8_t>(VT_HEADER_TYPE, 0));
  }
  const void *header() const {
    return GetPointer<const void *>(VT_HEADER);
  }
  template<typename T> const T *header_as() const;
  const org::apache::arrow::flatbuf::Schema *header_as_Schema() const {
    return header_type() == org::apache::arrow::flatbuf::MessageHeader_Schema ? static_cast<const org::apache::arrow::flatbuf::Schema *>(header()) : nullptr;
  }
  const org::apache::arrow::flatbuf::DictionaryBatch *header_as_DictionaryBatch() const {
    return header_type() == org::apache::arrow::flatbuf::MessageHeader_DictionaryBatch ? static_cast<const org::apache::arrow::flatbuf::DictionaryBatch *>(header()) : nullptr;
  }
  const org::apache::arrow::flatbuf::RecordBatch *header_as_RecordBatch() const {
    return header_type() == org::apache::arrow::flatbuf::MessageHeader_RecordBatch ? static_cast<const org::apache::arrow::flatbuf::RecordBatch *>(header()) : nullptr;
  }
  const org::apache::arrow::flatbuf::Tensor *header_as_Tensor() const {
    return header_type() == org::apache::arrow::flatbuf::MessageHeader_Tensor ? static_cast<const org::apache::arrow::flatbuf::Tensor *>(header()) : nullptr;
  }
  const org::apache::arrow::flatbuf::SparseTensor *header_as_SparseTensor() const {
    return header_type() == org::apache::arrow::flatbuf::MessageHeader_SparseTensor ? static_cast<const org::apache::arrow::flatbuf::SparseTensor *>(header()) : nullptr;
  }
  int64_t bodyLength() const {
    return GetField<int64_t>(VT_BODYLENGTH, 0);
  }
  const ::flatbuffers::Vector<::flatbuffers::Offset<org::apache::arrow::flatbuf::KeyValue>> *custom_metadata() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<org::apache::arrow::flatbuf::KeyValue>> *>(VT_CUSTOM_METADATA);
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<int16_t>(verifier, VT_VERSION, 2) &&
           VerifyField<uint8_t>(verifier, VT_HEADER_TYPE, 1) &&
           VerifyOffset(verifier, VT_HEADER) &&
           VerifyMessageHeader(verifier, header(), header_type()) &&
           VerifyField<int64_t>(verifier, VT_BODYLENGTH, 8) &&
           VerifyOffset(verifier, VT_CUSTOM_METADATA) &&
           verifier.VerifyVector(custom_metadata()) &&
           verifier.VerifyVectorOfTables(custom_metadata()) &&
           verifier.EndTable();
  }
  MessageT *UnPack(const ::flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(MessageT *_o, const ::flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static ::flatbuffers::Offset<Message> Pack(::flatbuffers::FlatBufferBuilder &_fbb, const MessageT* _o, const ::flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

template<> inline const org::apache::arrow::flatbuf::Schema *Message::header_as<org::apache::arrow::flatbuf::Schema>() const {
  return header_as_Schema();
}

template<> inline const org::apache::arrow::flatbuf::DictionaryBatch *Message::header_as<org::apache::arrow::flatbuf::DictionaryBatch>() const {
  return header_as_DictionaryBatch();
}

template<> inline const org::apache::arrow::flatbuf::RecordBatch *Message::header_as<org::apache::arrow::flatbuf::RecordBatch>() const {
  return header_as_RecordBatch();
}

template<> inline const org::apache::arrow::flatbuf::Tensor *Message::header_as<org::apache::arrow::flatbuf::Tensor>() const {
  return header_as_Tensor();
}

template<> inline const org::apache::arrow::flatbuf::SparseTensor *Message::header_as<org::apache::arrow::flatbuf::SparseTensor>() const {
  return header_as_SparseTensor();
}

struct MessageBuilder {
  typedef Message Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_version(org::apache::arrow::flatbuf::MetadataVersion version) {
    fbb_.AddElement<int16_t>(Message::VT_VERSION, static_cast<int16_t>(version), 0);
  }
  void add_header_type(org::apache::arrow::flatbuf::MessageHeader header_type) {
    fbb_.AddElement<uint8_t>(Message::VT_HEADER_TYPE, static_cast<uint8_t>(header_type), 0);
  }
  void add_header(::flatbuffers::Offset<void> header) {
    fbb_.AddOffset(Message::VT_HEADER, header);
  }
  void add_bodyLength(int64_t bodyLength) {
    fbb_.AddElement<int64_t>(Message::VT_BODYLENGTH, bodyLength, 0);
  }
  void add_custom_metadata(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<org::apache::arrow::flatbuf::KeyValue>>> custom_metadata) {
    fbb_.AddOffset(Message::VT_CUSTOM_METADATA, custom_metadata);
  }
  explicit MessageBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<Message> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<Message>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<Message> CreateMessage(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    org::apache::arrow::flatbuf::MetadataVersion version = org::apache::arrow::flatbuf::MetadataVersion_V1,
    org::apache::arrow::flatbuf::MessageHeader header_type = org::apache::arrow::flatbuf::MessageHeader_NONE,
    ::flatbuffers::Offset<void> header = 0,
    int64_t bodyLength = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<org::apache::arrow::flatbuf::KeyValue>>> custom_metadata = 0) {
  MessageBuilder builder_(_fbb);
  builder_.add_bodyLength(bodyLength);
  builder_.add_custom_metadata(custom_metadata);
  builder_.add_header(header);
  builder_.add_version(version);
  builder_.add_header_type(header_type);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<Message> CreateMessageDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    org::apache::arrow::flatbuf::MetadataVersion version = org::apache::arrow::flatbuf::MetadataVersion_V1,
    org::apache::arrow::flatbuf::MessageHeader header_type = org::apache::arrow::flatbuf::MessageHeader_NONE,
    ::flatbuffers::Offset<void> header = 0,
    int64_t bodyLength = 0,
    const std::vector<::flatbuffers::Offset<org::apache::arrow::flatbuf::KeyValue>> *custom_metadata = nullptr) {
  auto custom_metadata__ = custom_metadata ? _fbb.CreateVector<::flatbuffers::Offset<org::apache::arrow::flatbuf::KeyValue>>(*custom_metadata) : 0;
  return org::apache::arrow::flatbuf::CreateMessage(
      _fbb,
      version,
      header_type,
      header,
      bodyLength,
      custom_metadata__);
}

::flatbuffers::Offset<Message> CreateMessage(::flatbuffers::FlatBufferBuilder &_fbb, const MessageT *_o, const ::flatbuffers::rehasher_function_t *_rehasher = nullptr);

inline BodyCompressionT *BodyCompression::UnPack(const ::flatbuffers::resolver_function_t *_resolver) const {
  auto _o = std::unique_ptr<BodyCompressionT>(new BodyCompressionT());
  UnPackTo(_o.get(), _resolver);
  return _o.release();
}

inline void BodyCompression::UnPackTo(BodyCompressionT *_o, const ::flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = codec(); _o->codec = _e; }
  { auto _e = method(); _o->method = _e; }
}

inline ::flatbuffers::Offset<BodyCompression> BodyCompression::Pack(::flatbuffers::FlatBufferBuilder &_fbb, const BodyCompressionT* _o, const ::flatbuffers::rehasher_function_t *_rehasher) {
  return CreateBodyCompression(_fbb, _o, _rehasher);
}

inline ::flatbuffers::Offset<BodyCompression> CreateBodyCompression(::flatbuffers::FlatBufferBuilder &_fbb, const BodyCompressionT *_o, const ::flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { ::flatbuffers::FlatBufferBuilder *__fbb; const BodyCompressionT* __o; const ::flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _codec = _o->codec;
  auto _method = _o->method;
  return org::apache::arrow::flatbuf::CreateBodyCompression(
      _fbb,
      _codec,
      _method);
}

inline RecordBatchT::RecordBatchT(const RecordBatchT &o)
      : length(o.length),
        nodes(o.nodes),
        buffers(o.buffers),
        compression((o.compression) ? new org::apache::arrow::flatbuf::BodyCompressionT(*o.compression) : nullptr),
        variadicBufferCounts(o.variadicBufferCounts) {
}

inline RecordBatchT &RecordBatchT::operator=(RecordBatchT o) FLATBUFFERS_NOEXCEPT {
  std::swap(length, o.length);
  std::swap(nodes, o.nodes);
  std::swap(buffers, o.buffers);
  std::swap(compression, o.compression);
  std::swap(variadicBufferCounts, o.variadicBufferCounts);
  return *this;
}

inline RecordBatchT *RecordBatch::UnPack(const ::flatbuffers::resolver_function_t *_resolver) const {
  auto _o = std::unique_ptr<RecordBatchT>(new RecordBatchT());
  UnPackTo(_o.get(), _resolver);
  return _o.release();
}

inline void RecordBatch::UnPackTo(RecordBatchT *_o, const ::flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = length(); _o->length = _e; }
  { auto _e = nodes(); if (_e) { _o->nodes.resize(_e->size()); for (::flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->nodes[_i] = *_e->Get(_i); } } else { _o->nodes.resize(0); } }
  { auto _e = buffers(); if (_e) { _o->buffers.resize(_e->size()); for (::flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->buffers[_i] = *_e->Get(_i); } } else { _o->buffers.resize(0); } }
  { auto _e = compression(); if (_e) { if(_o->compression) { _e->UnPackTo(_o->compression.get(), _resolver); } else { _o->compression = std::unique_ptr<org::apache::arrow::flatbuf::BodyCompressionT>(_e->UnPack(_resolver)); } } else if (_o->compression) { _o->compression.reset(); } }
  { auto _e = variadicBufferCounts(); if (_e) { _o->variadicBufferCounts.resize(_e->size()); for (::flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->variadicBufferCounts[_i] = _e->Get(_i); } } else { _o->variadicBufferCounts.resize(0); } }
}

inline ::flatbuffers::Offset<RecordBatch> RecordBatch::Pack(::flatbuffers::FlatBufferBuilder &_fbb, const RecordBatchT* _o, const ::flatbuffers::rehasher_function_t *_rehasher) {
  return CreateRecordBatch(_fbb, _o, _rehasher);
}

inline ::flatbuffers::Offset<RecordBatch> CreateRecordBatch(::flatbuffers::FlatBufferBuilder &_fbb, const RecordBatchT *_o, const ::flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { ::flatbuffers::FlatBufferBuilder *__fbb; const RecordBatchT* __o; const ::flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _length = _o->length;
  auto _nodes = _o->nodes.size() ? _fbb.CreateVectorOfStructs(_o->nodes) : 0;
  auto _buffers = _o->buffers.size() ? _fbb.CreateVectorOfStructs(_o->buffers) : 0;
  auto _compression = _o->compression ? CreateBodyCompression(_fbb, _o->compression.get(), _rehasher) : 0;
  auto _variadicBufferCounts = _o->variadicBufferCounts.size() ? _fbb.CreateVector(_o->variadicBufferCounts) : 0;
  return org::apache::arrow::flatbuf::CreateRecordBatch(
      _fbb,
      _length,
      _nodes,
      _buffers,
      _compression,
      _variadicBufferCounts);
}

inline DictionaryBatchT::DictionaryBatchT(const DictionaryBatchT &o)
      : id(o.id),
        data((o.data) ? new org::apache::arrow::flatbuf::RecordBatchT(*o.data) : nullptr),
        isDelta(o.isDelta) {
}

inline DictionaryBatchT &DictionaryBatchT::operator=(DictionaryBatchT o) FLATBUFFERS_NOEXCEPT {
  std::swap(id, o.id);
  std::swap(data, o.data);
  std::swap(isDelta, o.isDelta);
  return *this;
}

inline DictionaryBatchT *DictionaryBatch::UnPack(const ::flatbuffers::resolver_function_t *_resolver) const {
  auto _o = std::unique_ptr<DictionaryBatchT>(new DictionaryBatchT());
  UnPackTo(_o.get(), _resolver);
  return _o.release();
}

inline void DictionaryBatch::UnPackTo(DictionaryBatchT *_o, const ::flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = id(); _o->id = _e; }
  { auto _e = data(); if (_e) { if(_o->data) { _e->UnPackTo(_o->data.get(), _resolver); } else { _o->data = std::unique_ptr<org::apache::arrow::flatbuf::RecordBatchT>(_e->UnPack(_resolver)); } } else if (_o->data) { _o->data.reset(); } }
  { auto _e = isDelta(); _o->isDelta = _e; }
}

inline ::flatbuffers::Offset<DictionaryBatch> DictionaryBatch::Pack(::flatbuffers::FlatBufferBuilder &_fbb, const DictionaryBatchT* _o, const ::flatbuffers::rehasher_function_t *_rehasher) {
  return CreateDictionaryBatch(_fbb, _o, _rehasher);
}

inline ::flatbuffers::Offset<DictionaryBatch> CreateDictionaryBatch(::flatbuffers::FlatBufferBuilder &_fbb, const DictionaryBatchT *_o, const ::flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { ::flatbuffers::FlatBufferBuilder *__fbb; const DictionaryBatchT* __o; const ::flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _id = _o->id;
  auto _data = _o->data ? CreateRecordBatch(_fbb, _o->data.get(), _rehasher) : 0;
  auto _isDelta = _o->isDelta;
  return org::apache::arrow::flatbuf::CreateDictionaryBatch(
      _fbb,
      _id,
      _data,
      _isDelta);
}

inline MessageT::MessageT(const MessageT &o)
      : version(o.version),
        header(o.header),
        bodyLength(o.bodyLength) {
  custom_metadata.reserve(o.custom_metadata.size());
  for (const auto &custom_metadata_ : o.custom_metadata) { custom_metadata.emplace_back((custom_metadata_) ? new org::apache::arrow::flatbuf::KeyValueT(*custom_metadata_) : nullptr); }
}

inline MessageT &MessageT::operator=(MessageT o) FLATBUFFERS_NOEXCEPT {
  std::swap(version, o.version);
  std::swap(header, o.header);
  std::swap(bodyLength, o.bodyLength);
  std::swap(custom_metadata, o.custom_metadata);
  return *this;
}

inline MessageT *Message::UnPack(const ::flatbuffers::resolver_function_t *_resolver) const {
  auto _o = std::unique_ptr<MessageT>(new MessageT());
  UnPackTo(_o.get(), _resolver);
  return _o.release();
}

inline void Message::UnPackTo(MessageT *_o, const ::flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = version(); _o->version = _e; }
  { auto _e = header_type(); _o->header.type = _e; }
  { auto _e = header(); if (_e) _o->header.value = org::apache::arrow::flatbuf::MessageHeaderUnion::UnPack(_e, header_type(), _resolver); }
  { auto _e = bodyLength(); _o->bodyLength = _e; }
  { auto _e = custom_metadata(); if (_e) { _o->custom_metadata.resize(_e->size()); for (::flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { if(_o->custom_metadata[_i]) { _e->Get(_i)->UnPackTo(_o->custom_metadata[_i].get(), _resolver); } else { _o->custom_metadata[_i] = std::unique_ptr<org::apache::arrow::flatbuf::KeyValueT>(_e->Get(_i)->UnPack(_resolver)); }; } } else { _o->custom_metadata.resize(0); } }
}

inline ::flatbuffers::Offset<Message> Message::Pack(::flatbuffers::FlatBufferBuilder &_fbb, const MessageT* _o, const ::flatbuffers::rehasher_function_t *_rehasher) {
  return CreateMessage(_fbb, _o, _rehasher);
}

inline ::flatbuffers::Offset<Message> CreateMessage(::flatbuffers::FlatBufferBuilder &_fbb, const MessageT *_o, const ::flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { ::flatbuffers::FlatBufferBuilder *__fbb; const MessageT* __o; const ::flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _version = _o->version;
  auto _header_type = _o->header.type;
  auto _header = _o->header.Pack(_fbb);
  auto _bodyLength = _o->bodyLength;
  auto _custom_metadata = _o->custom_metadata.size() ? _fbb.CreateVector<::flatbuffers::Offset<org::apache::arrow::flatbuf::KeyValue>> (_o->custom_metadata.size(), [](size_t i, _VectorArgs *__va) { return CreateKeyValue(*__va->__fbb, __va->__o->custom_metadata[i].get(), __va->__rehasher); }, &_va ) : 0;
  return org::apache::arrow::flatbuf::CreateMessage(
      _fbb,
      _version,
      _header_type,
      _header,
      _bodyLength,
      _custom_metadata);
}

inline bool VerifyMessageHeader(::flatbuffers::Verifier &verifier, const void *obj, MessageHeader type) {
  switch (type) {
    case MessageHeader_NONE: {
      return true;
    }
    case MessageHeader_Schema: {
      auto ptr = reinterpret_cast<const org::apache::arrow::flatbuf::Schema *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case MessageHeader_DictionaryBatch: {
      auto ptr = reinterpret_cast<const org::apache::arrow::flatbuf::DictionaryBatch *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case MessageHeader_RecordBatch: {
      auto ptr = reinterpret_cast<const org::apache::arrow::flatbuf::RecordBatch *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case MessageHeader_Tensor: {
      auto ptr = reinterpret_cast<const org::apache::arrow::flatbuf::Tensor *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case MessageHeader_SparseTensor: {
      auto ptr = reinterpret_cast<const org::apache::arrow::flatbuf::SparseTensor *>(obj);
      return verifier.VerifyTable(ptr);
    }
    default: return true;
  }
}

inline bool VerifyMessageHeaderVector(::flatbuffers::Verifier &verifier, const ::flatbuffers::Vector<::flatbuffers::Offset<void>> *values, const ::flatbuffers::Vector<uint8_t> *types) {
  if (!values || !types) return !values && !types;
  if (values->size() != types->size()) return false;
  for (::flatbuffers::uoffset_t i = 0; i < values->size(); ++i) {
    if (!VerifyMessageHeader(
        verifier,  values->Get(i), types->GetEnum<MessageHeader>(i))) {
      return false;
    }
  }
  return true;
}

inline void *MessageHeaderUnion::UnPack(const void *obj, MessageHeader type, const ::flatbuffers::resolver_function_t *resolver) {
  (void)resolver;
  switch (type) {
    case MessageHeader_Schema: {
      auto ptr = reinterpret_cast<const org::apache::arrow::flatbuf::Schema *>(obj);
      return ptr->UnPack(resolver);
    }
    case MessageHeader_DictionaryBatch: {
      auto ptr = reinterpret_cast<const org::apache::arrow::flatbuf::DictionaryBatch *>(obj);
      return ptr->UnPack(resolver);
    }
    case MessageHeader_RecordBatch: {
      auto ptr = reinterpret_cast<const org::apache::arrow::flatbuf::RecordBatch *>(obj);
      return ptr->UnPack(resolver);
    }
    case MessageHeader_Tensor: {
      auto ptr = reinterpret_cast<const org::apache::arrow::flatbuf::Tensor *>(obj);
      return ptr->UnPack(resolver);
    }
    case MessageHeader_SparseTensor: {
      auto ptr = reinterpret_cast<const org::apache::arrow::flatbuf::SparseTensor *>(obj);
      return ptr->UnPack(resolver);
    }
    default: return nullptr;
  }
}

inline ::flatbuffers::Offset<void> MessageHeaderUnion::Pack(::flatbuffers::FlatBufferBuilder &_fbb, const ::flatbuffers::rehasher_function_t *_rehasher) const {
  (void)_rehasher;
  switch (type) {
    case MessageHeader_Schema: {
      auto ptr = reinterpret_cast<const org::apache::arrow::flatbuf::SchemaT *>(value);
      return CreateSchema(_fbb, ptr, _rehasher).Union();
    }
    case MessageHeader_DictionaryBatch: {
      auto ptr = reinterpret_cast<const org::apache::arrow::flatbuf::DictionaryBatchT *>(value);
      return CreateDictionaryBatch(_fbb, ptr, _rehasher).Union();
    }
    case MessageHeader_RecordBatch: {
      auto ptr = reinterpret_cast<const org::apache::arrow::flatbuf::RecordBatchT *>(value);
      return CreateRecordBatch(_fbb, ptr, _rehasher).Union();
    }
    case MessageHeader_Tensor: {
      auto ptr = reinterpret_cast<const org::apache::arrow::flatbuf::TensorT *>(value);
      return CreateTensor(_fbb, ptr, _rehasher).Union();
    }
    case MessageHeader_SparseTensor: {
      auto ptr = reinterpret_cast<const org::apache::arrow::flatbuf::SparseTensorT *>(value);
      return CreateSparseTensor(_fbb, ptr, _rehasher).Union();
    }
    default: return 0;
  }
}

inline MessageHeaderUnion::MessageHeaderUnion(const MessageHeaderUnion &u) : type(u.type), value(nullptr) {
  switch (type) {
    case MessageHeader_Schema: {
      value = new org::apache::arrow::flatbuf::SchemaT(*reinterpret_cast<org::apache::arrow::flatbuf::SchemaT *>(u.value));
      break;
    }
    case MessageHeader_DictionaryBatch: {
      value = new org::apache::arrow::flatbuf::DictionaryBatchT(*reinterpret_cast<org::apache::arrow::flatbuf::DictionaryBatchT *>(u.value));
      break;
    }
    case MessageHeader_RecordBatch: {
      value = new org::apache::arrow::flatbuf::RecordBatchT(*reinterpret_cast<org::apache::arrow::flatbuf::RecordBatchT *>(u.value));
      break;
    }
    case MessageHeader_Tensor: {
      value = new org::apache::arrow::flatbuf::TensorT(*reinterpret_cast<org::apache::arrow::flatbuf::TensorT *>(u.value));
      break;
    }
    case MessageHeader_SparseTensor: {
      value = new org::apache::arrow::flatbuf::SparseTensorT(*reinterpret_cast<org::apache::arrow::flatbuf::SparseTensorT *>(u.value));
      break;
    }
    default:
      break;
  }
}

inline void MessageHeaderUnion::Reset() {
  switch (type) {
    case MessageHeader_Schema: {
      auto ptr = reinterpret_cast<org::apache::arrow::flatbuf::SchemaT *>(value);
      delete ptr;
      break;
    }
    case MessageHeader_DictionaryBatch: {
      auto ptr = reinterpret_cast<org::apache::arrow::flatbuf::DictionaryBatchT *>(value);
      delete ptr;
      break;
    }
    case MessageHeader_RecordBatch: {
      auto ptr = reinterpret_cast<org::apache::arrow::flatbuf::RecordBatchT *>(value);
      delete ptr;
      break;
    }
    case MessageHeader_Tensor: {
      auto ptr = reinterpret_cast<org::apache::arrow::flatbuf::TensorT *>(value);
      delete ptr;
      break;
    }
    case MessageHeader_SparseTensor: {
      auto ptr = reinterpret_cast<org::apache::arrow::flatbuf::SparseTensorT *>(value);
      delete ptr;
      break;
    }
    default: break;
  }
  value = nullptr;
  type = MessageHeader_NONE;
}

inline const org::apache::arrow::flatbuf::Message *GetMessage(const void *buf) {
  return ::flatbuffers::GetRoot<org::apache::arrow::flatbuf::Message>(buf);
}

inline const org::apache::arrow::flatbuf::Message *GetSizePrefixedMessage(const void *buf) {
  return ::flatbuffers::GetSizePrefixedRoot<org::apache::arrow::flatbuf::Message>(buf);
}

inline bool VerifyMessageBuffer(
    ::flatbuffers::Verifier &verifier) {
  return verifier.VerifyBuffer<org::apache::arrow::flatbuf::Message>(nullptr);
}

inline bool VerifySizePrefixedMessageBuffer(
    ::flatbuffers::Verifier &verifier) {
  return verifier.VerifySizePrefixedBuffer<org::apache::arrow::flatbuf::Message>(nullptr);
}

inline void FinishMessageBuffer(
    ::flatbuffers::FlatBufferBuilder &fbb,
    ::flatbuffers::Offset<org::apache::arrow::flatbuf::Message> root) {
  fbb.Finish(root);
}

inline void FinishSizePrefixedMessageBuffer(
    ::flatbuffers::FlatBufferBuilder &fbb,
    ::flatbuffers::Offset<org::apache::arrow::flatbuf::Message> root) {
  fbb.FinishSizePrefixed(root);
}

inline std::unique_ptr<org::apache::arrow::flatbuf::MessageT> UnPackMessage(
    const void *buf,
    const ::flatbuffers::resolver_function_t *res = nullptr) {
  return std::unique_ptr<org::apache::arrow::flatbuf::MessageT>(GetMessage(buf)->UnPack(res));
}

inline std::unique_ptr<org::apache::arrow::flatbuf::MessageT> UnPackSizePrefixedMessage(
    const void *buf,
    const ::flatbuffers::resolver_function_t *res = nullptr) {
  return std::unique_ptr<org::apache::arrow::flatbuf::MessageT>(GetSizePrefixedMessage(buf)->UnPack(res));
}

}  // namespace flatbuf
}  // namespace arrow
}  // namespace apache
}  // namespace org

#endif  // FLATBUFFERS_GENERATED_MESSAGE_ORG_APACHE_ARROW_FLATBUF_H_
