% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cohort}
\alias{cohort}
\alias{hld.r}
\alias{ovd.r}
\alias{ovc.r}
\alias{hlo.r}
\alias{ovo.r}
\title{NanoString Experiment Cohorts}
\format{\itemize{
\item \code{hld.r} Hodgkin Lymphoma Clinical Samples: a data frame with 232 rows and
77 columns
\item \code{ovd.r} Ovarian Cancer Clinical Samples: a data frame with 133 rows and 261
columns
\item \code{ovc.r} Ovarian Cancer Cell Lines: a data frame with 133 rows and 29
columns
\item \code{hlo.r} DNA Oligonucleotides for the HL CodeSet: a data frame with 40 rows
and 71 columns
\item \code{ovo.r} DNA Oligonucleotides for the OC CodeSet: a data frame with 133 rows
and 138 columns
}}
\source{
See Table 1 of
\url{https://journals.plos.org/plosone/article?id=10.1371/journal.pone.0153844}
for details.
}
\usage{
hld.r

ovd.r

ovc.r

hlo.r

ovo.r
}
\description{
There were five different cohorts used in NanoString experiments.
}
\details{
Each data object contains raw expression counts, so no normalization has been
applied. The format is a data frame with genes as rows, samples as columns.
Note that the first three columns contain gene metadata and are always
labelled "Code.Class", "Name", and "Accession", and the rest are sample
names. Hence, for the \code{hld.r} data, the raw counts are contained in 232 genes
for 77 - 3 = 74 samples. The total number of samples is 74 + 258 + 26 + 68 +
135 = 561, which matches the number of rows in \link{expQC}, the expression QC
data.
}
\seealso{
\link{expQC}
}
\keyword{datasets}
