% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\name{emr_track.import}
\alias{emr_track.import}
\title{Imports a track from a file or data-frame}
\usage{
emr_track.import(track, space, categorical, src, override = FALSE)
}
\arguments{
\item{track}{the name of the newly created track}

\item{space}{db dir string (path), one of the paths supplied in emr_db.connect}

\item{categorical}{if 'TRUE' track is marked as categorical}

\item{src}{file name or data-frame containing the track records}

\item{override}{Boolean indicating whether the creation intends to override an existing track (default FALSE)}
}
\value{
None.
}
\description{
Imports a track from a file or data-frame.
}
\details{
This function creates a new track from a text file or a data-frame.
The location of the track is controlled via 'space' parameter which
can be any of the db_dirs supplied in emr_db.connect.

If 'src' is a file name, the latter must be constituted of four columns
separated by spaces or 'TAB' characters: ID, time, reference and value. The
file might contain lines of comments which should start with a '#'
character.

Alternatively 'src' can be an ID-Time Values table, which is a data frame with
the following columns: "id" "time" "ref" and "value". Note that the
file should not contain a header.

(see "User Manual" for more info).
}
\seealso{
\code{\link{emr_track.addto}}, \code{\link{emr_track.create}},
\code{\link{emr_track.readonly}}, \code{\link{emr_db.init}},
\code{\link{emr_track.ls}}
}
\keyword{~import}
