% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_driver.R
\name{get_driver_info}
\alias{get_driver_info}
\title{Get NASCAR driver statistics}
\usage{
get_driver_info(driver, series = "all", type = "summary")
}
\arguments{
\item{driver}{Character string of driver name (case-insensitive, fuzzy matching
available)}

\item{series}{Character string specifying the racing series to analyze. Must be
one of:
\itemize{
\item 'all' (default)
\item 'Cup'
\item 'Xfinity'
\item 'Truck'
}}

\item{type}{Character string specifying the type of summary to return. Must be
one of:
\itemize{
\item 'summary' (default): Career statistics grouped by series
\item 'season': Season-by-season statistics for each series
\item 'all': Complete race-by-race data
}}
}
\value{
A tibble containing driver statistics based on the specified type:
\itemize{
\item For type = 'summary': Career statistics grouped by series
\item For type = 'season': Season-by-season breakdown
\item For type = 'all': Complete race-by-race data
}
}
\description{
Retrieves and summarizes NASCAR race statistics for a specified driver across
different racing series. The function provides flexibility in viewing career
summaries, season-by-season breakdowns, or complete race-by-race data.
}
\examples{
if (interactive()) {
  # Get career summary for Kyle Busch across all series
  get_driver_info("Kyle Busch")

  # Get Cup series statistics only
  get_driver_info("Kyle Busch", series = "cup")

  # Get season-by-season breakdown for Truck series
  get_driver_info("Kyle Busch", series = "truck", type = "season")
}

}
