% Generated by roxygen2 (4.0.2): do not edit by hand
\name{as.templatebrain}
\alias{as.templatebrain}
\alias{as.templatebrain.character}
\alias{as.templatebrain.im3d}
\title{Use image file or other object to initialise template brain}
\usage{
as.templatebrain(x, ...)

\method{as.templatebrain}{character}(x, ...)

\method{as.templatebrain}{im3d}(x, name = NULL, regName = NULL, ...)
}
\arguments{
\item{x}{object used to construct the templatebrain, either a character
vector with the path to a file or an \code{im3d} object.}

\item{...}{additional named arguments passed to methods and then on to
\code{templatebrain} that will be added as fields to the
\code{templatebrain} object.}

\item{name,regName}{name and short name of the template brain. Will use the
filename (minus final extension) by default for both fields.}
}
\value{
A list with class \code{templatebrain}.
}
\description{
Use image file or other object to initialise template brain
}
\examples{
# Make templatebrain object using image info from the template brain NRRD file
nhdr=system.file('images','FCWB.nhdr', package='nat.templatebrains')
as.templatebrain(nhdr, name = "FlyCircuit Whole Brain")
}
\seealso{
\code{\link[nat]{im3d}}
}

