% Generated by roxygen2 (4.0.1): do not edit by hand
\name{is.gzip}
\alias{is.gzip}
\title{Check if a file is a gzip file}
\usage{
is.gzip(f)
}
\arguments{
\item{f}{Path to file to test}
}
\value{
logical indicating whether \code{f} is in gzip format (or \code{NA}
  if the file cannot be accessed)
}
\description{
Check if a file is a gzip file
}
\examples{
\dontrun{
notgzipfile=tempfile()
writeLines('not a gzip', notgzipfile)
is.gzip(notgzipfile)
con=gzfile(gzipfile<-tempfile(),open='wt')
writeLines('This one is gzipped', con)
is.gzip(gzipfile)
unlink(c(notgzipfile,gzipfile))
}
}

