% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ngraph.R
\name{prune_strahler}
\alias{prune_strahler}
\title{Prune a neuron by removing segments with a given Strahler order}
\usage{
prune_strahler(x, orderstoprune = 1:2, ...)
}
\arguments{
\item{x}{A \code{neuron}}

\item{orderstoprune}{Integer indices of which Strahler orders to prune -
defaults to the lowest two orders (\code{1:2})}

\item{...}{Additional arguments passed to \code{\link{as.neuron.data.frame}}}
}
\value{
The pruned \code{neuron}
}
\description{
Prune a neuron by removing segments with a given Strahler order
}
\examples{
x=Cell07PNs[[1]]
pruned12=prune_strahler(x)
pruned1=prune_strahler(x, 1)
plot(x)
plot(pruned1, lwd=3, col='blue', add=TRUE)
plot(pruned12, lwd=3, col='red', add=TRUE)
}
\seealso{
\code{\link{strahler_order}}, \code{\link{spine}}, for finding the
  longest path in a neuron, \code{\link{prune}} for subsetting
  \code{dotprops} style neurons by spatial proximity,
  \code{\link{as.neuron.data.frame}}, which is used to generate the new
  neuron.
}

