% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neuron-io.R
\name{write.neurons}
\alias{write.neurons}
\title{Write neurons from a neuronlist object to individual files, or a zip archive}
\usage{
write.neurons(nl, dir, format = NULL, subdir = NULL, INDICES = names(nl),
  files = NULL, Force = FALSE, ...)
}
\arguments{
\item{nl}{neuronlist object}

\item{dir}{directory to write neurons, or path to zip archive (see Details).}

\item{format}{Unique abbreviation of one of the registered file formats for 
neurons including 'swc', 'hxlineset', 'hxskel'}

\item{subdir}{String naming field in neuron that specifies a subdirectory OR 
expression to evaluate in the context of neuronlist's df attribute}

\item{INDICES}{Character vector of the names of a subset of neurons in 
neuronlist to write.}

\item{files}{Character vector or expression specifying output filenames. See 
examples and \code{\link{write.neuron}} for details.}

\item{Force}{Whether to overwrite an existing file}

\item{...}{Additional arguments passed to \code{\link{write.neuron}}}
}
\value{
the path to the output file(s), absolute when this is a zip file.
}
\description{
Write neurons from a neuronlist object to individual files, or a zip archive
}
\details{
See \code{\link{write.neuron}} for details of how to specify the 
  file format/extension/name of the output files and how to establish what 
  output file formats are available. A zip archive of files can be written by
  specifying a value of \code{dir} that ends in \code{.zip}.
}
\examples{
\dontrun{
# write some neurons in swc format
write.neurons(Cell07PNs, dir="testwn", format='swc')
# write some neurons in Amira hxlineset format
write.neurons(Cell07PNs, dir="testwn", format='hxlineset')

# organise new files in directory hierarchy by glomerulus and Scored.By field
write.neurons(Cell07PNs,dir="testwn",
  subdir=file.path(Glomerulus,Scored.By),format='hxlineset')
# ensure that the neurons are named according to neuronlist names
write.neurons(Cell07PNs, dir="testwn", files=names(Cell07PNs),
  subdir=file.path(Glomerulus,Scored.By),format='hxlineset')
# only write a subset
write.neurons(subset(Cell07PNs, Scored.By="ACH"),dir="testwn2",
  subdir=Glomerulus,format='hxlineset')
# The same, but likely faster for big neuronlists
write.neurons(Cell07PNs, dir="testwn3",
  INDICES=subset(Cell07PNs,Scored.By="ACH",rval='names'),
  subdir=Glomerulus,format='hxlineset')
# set file name explicitly using a field in data.frame
write.neurons(subset(Cell07PNs, Scored.By="ACH"),dir="testwn4",
  subdir=Glomerulus, files=paste0(ID,'.am'), format='hxlineset')
}
}
\author{
jefferis
}
\seealso{
\code{\link{write.neuron}}, \code{\link{read.neurons}},
  \code{\link{fileformats}}

Other neuronlist: \code{\link{*.neuronlist}},
  \code{\link{is.neuronlist}},
  \code{\link{neuronlist-dataframe-methods}},
  \code{\link{neuronlistfh}}, \code{\link{neuronlist}},
  \code{\link{nlapply}}, \code{\link{read.neurons}}
}

