% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-nodes.R
\name{rootpoints}
\alias{rootpoints}
\alias{rootpoints.default}
\alias{rootpoints.neuron}
\alias{rootpoints.igraph}
\alias{branchpoints}
\alias{branchpoints.default}
\alias{branchpoints.neuron}
\alias{branchpoints.igraph}
\alias{endpoints}
\alias{endpoints.neuron}
\alias{endpoints.igraph}
\alias{endpoints.default}
\title{Return the root or branch points of a neuron or graph}
\usage{
rootpoints(x, ...)

\method{rootpoints}{default}(x, ...)

\method{rootpoints}{neuron}(x, subtrees = 1, ...)

\method{rootpoints}{igraph}(x, ...)

branchpoints(x, ...)

\method{branchpoints}{default}(x, ...)

\method{branchpoints}{neuron}(x, subtrees = 1, ...)

\method{branchpoints}{igraph}(x, ...)

endpoints(x, ...)

\method{endpoints}{neuron}(x, subtrees = 1, ...)

\method{endpoints}{igraph}(x, ...)

\method{endpoints}{default}(x, ...)
}
\arguments{
\item{x}{Neuron or other object which might have roots}

\item{...}{Further arguments passed to methods}

\item{subtrees}{Integer index of the fully connected subtree in 
\code{x$SubTrees}. Only applicable when a \code{neuron} consists of 
multiple unconnected subtrees.}
}
\value{
Integer point number of root/branch point
}
\description{
A neuron may have multiple subtrees and therefore multiple roots

Return the branchpoints of a neuron or graph
}
\details{
\code{branchpoints.neuron} returns a list if more than one subtree is
  specified
}
\seealso{
Other neuron: \code{\link{neuron}}, \code{\link{ngraph}},
  \code{\link{plot.neuron}},
  \code{\link{potential_synapses}}, \code{\link{prune}},
  \code{\link{resample}}, \code{\link{spine}},
  \code{\link{subset.neuron}}
}
