% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcR.R
\name{estimateRt}
\alias{estimateRt}
\title{Estimates time-level reproductive numbers}
\usage{
estimateRt(riData, dateVar, timeFrame = c("days", "weeks", "months", "years"))
}
\arguments{
\item{riData}{The name of the dateset with individual-level reproductive numbers.}

\item{dateVar}{The variable name (in quotes) of the dates that the individuals are observed
(data frame \code{riData}  must have a variable called \code{<dateVar>}).}

\item{timeFrame}{The time frame used to calculate Rt
(one of \code{"days", "months", "weeks", "years"}).}
}
\value{
A data frame with the time-level reproductive numbers. Column names:
     \itemize{
       \item \code{time} - the time frame corresponding to the reproductive number estimate 
       (day for "days" and "weeks", month for "months", year for "years").
       \item \code{timeRank} - the rank of the time frame.
       \item \code{Rt} - the time-level reproductive number for this time frame.
     }
}
\description{
The function \code{estimateRt} estimates the time-level effective reproductive number
from individual-level reproductive numbers.
}
\details{
This function is meant to be called by \code{\link{estimateR}}
which estimates the individual-level and time-level, and average reproductive numbers, 
but it can also be run directly.
}
\seealso{
\code{\link{estimateR}} \code{\link{estimateRi}} \code{\link{estimateRtAvg}}
}
