% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbc4va_help.R
\name{nbc4vaHelpBasic}
\alias{nbc4vaHelpBasic}
\title{Basic usage in nbc4va}
\usage{
nbc4vaHelpBasic()
}
\description{
Basic usage in nbc4va
}
\section{About}{

This documentation page provides details on the basic usage of the nbc4va package which includes bringing up
the Graphic User Interface and running the Naive Bayes Classifier algorithm using file input and output.
}

\section{User Interface}{

The simplest way to use the package is to open the Graphical User Interface (GUI) in your default web browser with \code{\link{nbc4vaGUI}()}. \cr \cr
Once the GUI is loaded, follow the instructions to fit a NBC model to your \file{training.csv} and to evaluate its performance with your \file{testing.csv} data.
\subsection{Example of GUI}{
  If \code{\link{nbc4vaGUI}} is called sucessfully, the GUI shown in the image below should be available in your web browser. \cr \cr
  \figure{nbcguiex.png} \cr \cr
}
\subsection{Sample Code for GUI}{
  Run the following code using \code{\link{nbc4vaGUI}} in the R console to open the GUI in your web browser.\cr\cr
  Close the GUI by pressing escape while you are in the R console.
  \preformatted{
--------------------------------------------------------------------------------------------------

    library(nbc4va)  # load the package
    nbc4vaGUI()  # open the GUI in your web browser

--------------------------------------------------------------------------------------------------
  }
}
\subsection{References for GUI}{
  \itemize{
    \item See the \code{\link{nbc4vaHelpMethods}} section for definitions of performance metrics and terms in the model results
  }
}
}

\section{File Input and Output}{

The \code{\link{nbc4vaIO}} function can be called to fit a NBC model and save its results
using the paths to your \file{training} and \file{testing} files in Comma Separated Values (CSV) format. \cr \cr
The saved results will in a selected directory with four CSV files detailing the performance of the model:
\itemize{
  \item \file{.._pred.csv}: a table of predictions, where the columns Prediction1..PredictionN are the cause of death predictions with Prediction1 being the most probable cause
  \item \file{.._prob.csv}: a table of probabilities, where each column is a cause of death and each cell is the probability of a case being that cause
  \item \file{.._causes.csv}: a table of metrics for each cause
  \item \file{.._metrics.csv}: a table of summary metrics for the model
  \item The \emph{..} represents the name of your \file{testing} file
}
\subsection{Example of File Input and Output}{
 The image below shows the input files on the left and the saved results on the right using the \code{\link{nbc4vaIO}} function (with the \emph{fileHeader} argument set to "nbc4va"). \cr \cr
 \figure{nbcioex.png}
}
\subsection{Sample Code for File Input and Output}{
  Run the following code using \code{\link{nbc4vaIO}} in the R console to produce NBC model performance results with the \file{training} and \file{testing} files.
  \preformatted{
--------------------------------------------------------------------------------------------------

    library(nbc4va)

    # Find paths to your "trainFile" and "testFile"
    trainFile <- file.choose()  # select train file first
    testFile <- file.choose()  # followed by test file after

    # Run NBC model and dump results to the same directory as the "testFile"
    nbc4vaIO(trainFile, testFile, known=TRUE)  # set known to indicate whether testing causes are known

--------------------------------------------------------------------------------------------------
  }
}
\subsection{References for File Input and Output}{
  \itemize{
    \item See \code{\link{nbc4vaIO}} for complete function specifications and usage
    \item See the \code{\link{nbc4vaHelpData}} section for \file{training} and \file{testing} file formats
    \item See the \code{\link{nbc4vaHelpMethods}} section for definitions of performance metrics and terms in the model results
  }
}
}
\seealso{
Guide for package: \code{\link{nbc4va}}

Other help functions: \code{\link{nbc4vaHelpAdvanced}},
  \code{\link{nbc4vaHelpData}},
  \code{\link{nbc4vaHelpDev}},
  \code{\link{nbc4vaHelpFunctions}},
  \code{\link{nbc4vaHelpMethods}}, \code{\link{nbc4vaHelp}}
}

