% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbfar.R
\name{nbfar_control}
\alias{nbfar_control}
\title{Control parameters for NBFAR and NBRRR}
\usage{
nbfar_control(
  maxit = 5000,
  epsilon = 1e-07,
  elnetAlpha = 0.95,
  gamma0 = 1,
  spU = 0.5,
  spV = 0.5,
  lamMaxFac = 1,
  lamMinFac = 1e-06,
  initmaxit = 10000,
  initepsilon = 1e-08,
  objI = 0
)
}
\arguments{
\item{maxit}{maximum iteration for each sequential steps}

\item{epsilon}{tolerance value required for convergence of inner loop in GCURE}

\item{elnetAlpha}{elastic net penalty parameter}

\item{gamma0}{power parameter for generating the adaptive weights}

\item{spU}{maximum proportion of nonzero elements in each column of U}

\item{spV}{maximum proportion of nonzero elements in each column of V}

\item{lamMaxFac}{a multiplier of the computed maximum value (lambda_max) of the tuning parameter}

\item{lamMinFac}{a multiplier to determine lambda_min as a fraction of lambda_max}

\item{initmaxit}{maximum iteration for minimizing the objective function while computing the initial estimates of the model parameter}

\item{initepsilon}{tolerance value required for the convergence of the objective function while computing the initial estimates of the model parameter}

\item{objI}{1 or 0  to indicate that the convergence will be on the basis of objective function or not}
}
\value{
a list of controlling parameter.
}
\description{
Default value for a list of control parameters that are used to estimate the parameters of negative binomial co-sparse factor regression (NBFAR) and negative binomial reduced rank regression (NBRRR).
}
\examples{
control <- nbfar_control()
}
\references{
Mishra, A., Müller, C. (2022) \emph{Negative binomial factor regression models with application to microbiome data analysis.  https://doi.org/10.1101/2021.11.29.470304}
}
